/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.time.Duration;
import java.time.Instant;
import net.thevpc.nuts.concurrent.NRateLimitDefaultStrategy;
import net.thevpc.nuts.concurrent.NRateLimitRule;
import net.thevpc.nuts.concurrent.NRateLimitRuleModel;

public class NRateLimitBucketRule
implements NRateLimitRule {
    private String id;
    private int capacity;
    private Duration duration;
    private int available;
    private Instant lastRefill;

    public NRateLimitBucketRule(NRateLimitRuleModel model) {
        this.id = model.getId();
        this.capacity = model.getCapacity();
        this.available = (int)model.getAvailable();
        this.duration = model.getDuration() == 0L ? null : Duration.ofMillis(model.getDuration());
        this.lastRefill = model.getLastRefill() == 0L ? null : Instant.ofEpochMilli(model.getLastRefill());
    }

    @Override
    public synchronized boolean tryConsume(int count) {
        this.refill();
        if (this.available >= count) {
            this.available -= count;
            return true;
        }
        return false;
    }

    @Override
    public synchronized long nextAvailableMillis(int count) {
        if (this.available >= count) {
            return 0L;
        }
        long periodMs = this.duration.toMillis();
        long neededTokens = count - this.available;
        double msPerToken = (double)periodMs / (double)this.capacity;
        long elapsed = Duration.between(this.lastRefill, Instant.now()).toMillis();
        return Math.max((long)((double)neededTokens * msPerToken - (double)elapsed), 0L);
    }

    public synchronized void refill() {
        if (this.lastRefill == null) {
            this.lastRefill = Instant.now();
            this.available = this.capacity;
            return;
        }
        long periodMs = this.duration.toMillis();
        long elapsed = Duration.between(this.lastRefill, Instant.now()).toMillis();
        if (elapsed >= periodMs) {
            long cycles = elapsed / periodMs;
            this.available = Math.min(this.capacity, this.available + (int)(cycles * (long)this.capacity));
            this.lastRefill = this.lastRefill.plusMillis(cycles * periodMs);
        }
    }

    @Override
    public synchronized NRateLimitRuleModel toModel() {
        return new NRateLimitRuleModel(this.id, NRateLimitDefaultStrategy.BUCKET.id(), this.capacity, this.duration == null ? 0L : this.duration.toMillis(), this.available, this.lastRefill == null ? 0L : this.lastRefill.toEpochMilli(), new byte[0]);
    }

    public String toString() {
        return "Bucket{id='" + this.id + '\'' + ", capacity=" + this.capacity + ", duration=" + this.duration + '}';
    }
}

