/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.UUID;
import net.thevpc.nuts.concurrent.NCallable;
import net.thevpc.nuts.concurrent.NWorkBalancerJob;
import net.thevpc.nuts.concurrent.NWorkBalancerStrategyEvent;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerJobContextImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerWorkerImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.NWorkBalancerWorkerLoadImpl;
import net.thevpc.nuts.runtime.standalone.concurrent.WorkBalancerRunningJob;

class NCallableFromJob<T>
implements NCallable<T> {
    private final NWorkBalancerImpl nWorkBalancer;
    private final NWorkBalancerJob<T> job;
    private final String jobName;

    public NCallableFromJob(NWorkBalancerImpl nWorkBalancer, String jobName, NWorkBalancerJob<T> job) {
        this.nWorkBalancer = nWorkBalancer;
        this.job = job;
        this.jobName = jobName;
    }

    @Override
    public T call() {
        NWorkBalancerWorkerLoadImpl selectedWorker = this.nWorkBalancer.selectWorker();
        String jobId = UUID.randomUUID().toString();
        long startNano = System.nanoTime();
        selectedWorker.totalJobsCount.incrementAndGet();
        selectedWorker.activeJobsCount.incrementAndGet();
        WorkBalancerRunningJob<T> runningJob = new WorkBalancerRunningJob<T>(this.job, jobId, this.jobName, selectedWorker.worker.getName(), startNano);
        this.nWorkBalancer.runningJobs.add(runningJob);
        selectedWorker.runningJobs.add(runningJob);
        this.nWorkBalancer.strategy.onStartCall(new NWorkBalancerStrategyEvent(jobId, this.jobName, selectedWorker.worker.getName(), startNano, 0L, null));
        RuntimeException throwable = null;
        try {
            T result = this.job.call(new NWorkBalancerJobContextImpl(jobId, this.jobName, new NWorkBalancerWorkerImpl(selectedWorker.worker), selectedWorker.getWorkerIndex(), this.nWorkBalancer.model));
            selectedWorker.succeededJobCount.incrementAndGet();
            T t = result;
            return t;
        }
        catch (RuntimeException ex) {
            throwable = ex;
            throw ex;
        }
        finally {
            long endNano = System.nanoTime();
            runningJob.setEndNano(endNano);
            runningJob.setThrowable(throwable);
            this.nWorkBalancer.runningJobs.remove(runningJob);
            selectedWorker.runningJobs.remove(runningJob);
            if (throwable != null) {
                selectedWorker.failedJobsCount.incrementAndGet();
            }
            selectedWorker.completedJobsTotalDurationNano.addAndGet(endNano - startNano);
            selectedWorker.activeJobsCount.decrementAndGet();
            this.nWorkBalancer.strategy.onEndCall(new NWorkBalancerStrategyEvent(jobId, this.jobName, selectedWorker.worker.getName(), startNano, endNano, throwable));
        }
    }
}

