/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.UUID;
import java.util.function.Supplier;
import net.thevpc.nuts.concurrent.NCachedValue;
import net.thevpc.nuts.concurrent.NCachedValueFactory;
import net.thevpc.nuts.concurrent.NCachedValueModel;
import net.thevpc.nuts.concurrent.NCachedValueStore;
import net.thevpc.nuts.runtime.standalone.concurrent.NCachedValueImpl;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;

public class NCachedValueFactoryImpl
implements NCachedValueFactory {
    private NCachedValueStore store;

    public NCachedValueFactoryImpl(NCachedValueStore store) {
        this.store = store;
    }

    @Override
    public <T> NCachedValue<T> of(Supplier<T> supplier) {
        return this.of(UUID.randomUUID().toString(), supplier);
    }

    @Override
    public <T> NCachedValue<T> of(String id, Supplier<T> supplier) {
        String nid = NBlankable.isBlank(id) ? UUID.randomUUID().toString() : id;
        return new NCachedValueImpl<T>(nid, NAssert.requireNonNull(supplier, "supplier"), this);
    }

    public NCachedValueModel load(String id) {
        return this.store.load(id);
    }

    public void save(NCachedValueModel rateLimitValue) {
        this.store.save(rateLimitValue);
    }
}

