/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import net.thevpc.nuts.concurrent.NBulkheadCallBackend;
import net.thevpc.nuts.concurrent.NBulkheadMetrics;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NOptional;

public class NBulkheadCallBackendAsSemaphore
implements NBulkheadCallBackend {
    private final ConcurrentHashMap<String, BulkheadState> bulkheads = new ConcurrentHashMap();

    @Override
    public NOptional<NBulkheadCallBackend.NBulkheadPermit> tryAcquire(String bulkheadId, int maxConcurrent) {
        BulkheadState state = this.getOrCreateBulkhead(bulkheadId, maxConcurrent);
        if (state.semaphore.tryAcquire()) {
            state.activeCount.incrementAndGet();
            state.totalAcquired.incrementAndGet();
            return NOptional.of(new SemaphorePermitN(bulkheadId, UUID.randomUUID().toString(), System.currentTimeMillis(), Thread.currentThread().getId()));
        }
        state.totalRejected.incrementAndGet();
        return NOptional.ofEmpty();
    }

    @Override
    public NOptional<NBulkheadCallBackend.NBulkheadPermit> tryAcquire(String bulkheadId, int maxConcurrent, NDuration timeout) {
        BulkheadState state = this.getOrCreateBulkhead(bulkheadId, maxConcurrent);
        if (timeout == null) {
            timeout = NDuration.ofMillis(Long.MAX_VALUE);
        }
        try {
            long startTime = System.currentTimeMillis();
            boolean acquired = state.semaphore.tryAcquire(timeout.toMillis(), TimeUnit.MILLISECONDS);
            if (acquired) {
                state.activeCount.incrementAndGet();
                state.totalAcquired.incrementAndGet();
                long waitTime = System.currentTimeMillis() - startTime;
                state.updateMaxWaitTime(waitTime);
                return NOptional.of(new SemaphorePermitN(bulkheadId, UUID.randomUUID().toString(), System.currentTimeMillis(), Thread.currentThread().getId()));
            }
            state.totalRejected.incrementAndGet();
            return NOptional.ofEmpty();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            state.totalRejected.incrementAndGet();
            return NOptional.ofEmpty();
        }
    }

    @Override
    public void release(NBulkheadCallBackend.NBulkheadPermit permit) {
        BulkheadState state = this.bulkheads.get(permit.getBulkheadId());
        if (state != null) {
            state.semaphore.release();
            state.activeCount.decrementAndGet();
            state.totalReleased.incrementAndGet();
            long duration = System.currentTimeMillis() - permit.getAcquiredAt();
            state.updateMaxHoldTime(duration);
        }
    }

    @Override
    public NBulkheadMetrics getMetrics(String bulkheadId) {
        BulkheadState state = this.bulkheads.get(bulkheadId);
        if (state == null) {
            return new NBulkheadMetrics(bulkheadId, 0, 0, 0, 0L, 0L, 0L, 0L, 0L);
        }
        return new NBulkheadMetrics(bulkheadId, state.maxConcurrent, state.activeCount.get(), state.semaphore.availablePermits(), state.totalAcquired.get(), state.totalReleased.get(), state.totalRejected.get(), state.maxWaitTime.get(), state.maxHoldTime.get());
    }

    @Override
    public int cleanupExpired(String bulkheadId, NDuration expiryDuration) {
        return 0;
    }

    private BulkheadState getOrCreateBulkhead(String bulkheadId, int maxConcurrent) {
        return this.bulkheads.compute(bulkheadId, (id, existing) -> {
            if (existing == null) {
                return new BulkheadState(maxConcurrent);
            }
            if (((BulkheadState)existing).maxConcurrent != maxConcurrent) {
                existing.resize(maxConcurrent);
            }
            return existing;
        });
    }

    private static class BulkheadState {
        private volatile Semaphore semaphore;
        private volatile int maxConcurrent;
        private final AtomicInteger activeCount = new AtomicInteger(0);
        private final AtomicLong totalAcquired = new AtomicLong(0L);
        private final AtomicLong totalReleased = new AtomicLong(0L);
        private final AtomicLong totalRejected = new AtomicLong(0L);
        private final AtomicLong maxWaitTime = new AtomicLong(0L);
        private final AtomicLong maxHoldTime = new AtomicLong(0L);

        BulkheadState(int maxConcurrent) {
            this.maxConcurrent = maxConcurrent;
            this.semaphore = new Semaphore(maxConcurrent, true);
        }

        void resize(int newMaxConcurrent) {
            int delta = newMaxConcurrent - this.maxConcurrent;
            if (delta > 0) {
                this.semaphore.release(delta);
            } else if (delta < 0) {
                this.semaphore.acquireUninterruptibly(-delta);
            }
            this.maxConcurrent = newMaxConcurrent;
        }

        void updateMaxWaitTime(long waitTime) {
            long current;
            while (waitTime > (current = this.maxWaitTime.get()) && !this.maxWaitTime.compareAndSet(current, waitTime)) {
            }
        }

        void updateMaxHoldTime(long holdTime) {
            long current;
            while (holdTime > (current = this.maxHoldTime.get()) && !this.maxHoldTime.compareAndSet(current, holdTime)) {
            }
        }
    }

    private static class SemaphorePermitN
    implements NBulkheadCallBackend.NBulkheadPermit {
        private final String bulkheadId;
        private final String permitId;
        private final long acquiredAt;
        private final long threadId;

        SemaphorePermitN(String bulkheadId, String permitId, long acquiredAt, long threadId) {
            this.bulkheadId = bulkheadId;
            this.permitId = permitId;
            this.acquiredAt = acquiredAt;
            this.threadId = threadId;
        }

        @Override
        public String getBulkheadId() {
            return this.bulkheadId;
        }

        @Override
        public String getPermitId() {
            return this.permitId;
        }

        @Override
        public long getAcquiredAt() {
            return this.acquiredAt;
        }

        public long getThreadId() {
            return this.threadId;
        }
    }
}

