/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.concurrent.NLock;
import net.thevpc.nuts.concurrent.NLockException;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.concurrent.AbstractNLockBuilder;
import net.thevpc.nuts.runtime.standalone.concurrent.DefaultFileNLock;
import net.thevpc.nuts.runtime.standalone.concurrent.DefaultMemLock;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNLockBuilder
extends AbstractNLockBuilder {
    Map<Object, DefaultMemLock> memLocks = new HashMap<Object, DefaultMemLock>();

    @Override
    public NLock build() {
        Object s = this.getSource();
        Object lr = this.getResource();
        Path lrPath = null;
        if (lr == null) {
            if (s == null) {
                throw new NLockException(NMsg.ofPlain("unsupported lock for null"), null, null);
            }
            Path p = this.toPath(s);
            if (p == null) {
                return this.memLocks.computeIfAbsent(s, e -> new DefaultMemLock(e));
            }
            lrPath = p.resolveSibling(p.getFileName().toString() + ".lock");
            return new DefaultFileNLock(lrPath, s);
        }
        lrPath = this.toPath(lr);
        if (lrPath == null) {
            return this.memLocks.computeIfAbsent(lr, e -> new DefaultMemLock(e));
        }
        return new DefaultFileNLock(lrPath, s);
    }

    private Path toPath(Object lockedObject) {
        if (lockedObject instanceof Path) {
            return (Path)lockedObject;
        }
        if (lockedObject instanceof NPath) {
            return ((NPath)lockedObject).toPath().get();
        }
        if (lockedObject instanceof File) {
            return ((File)lockedObject).toPath();
        }
        return null;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

