/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.thevpc.nuts.concurrent.NLock;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;

public abstract class AbstractNLock
implements NLock {
    @Override
    public void runWith(Runnable runnable) {
        try {
            this.lock();
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public <T> T callWith(Callable<T> callable) {
        this.lock();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean runWithImmediately(Runnable runnable) {
        if (this.isHeldByCurrentThread()) {
            this.relock();
            try {
                runnable.run();
            }
            finally {
                this.reunlock();
            }
            return true;
        }
        if (this.tryLock()) {
            try {
                runnable.run();
                boolean bl = true;
                return bl;
            }
            finally {
                this.unlock();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean runWith(Runnable runnable, long time, TimeUnit unit) {
        boolean bl;
        if (this.isHeldByCurrentThread()) {
            this.relock();
            try {
                runnable.run();
                return true;
            }
            finally {
                this.reunlock();
            }
        }
        if (!this.tryLock(time, unit)) return false;
        try {
            runnable.run();
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                this.unlock();
                throw throwable;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        this.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> NOptional<T> callWithImmediately(Callable<T> callable) {
        if (this.isHeldByCurrentThread()) {
            this.relock();
            try {
                NOptional<T> nOptional = NOptional.of(callable.call());
                return nOptional;
            }
            catch (Exception e) {
                NOptional nOptional = NOptional.ofError(NMsg.ofC("error call %s", e), (Throwable)e);
                return nOptional;
            }
            finally {
                this.reunlock();
            }
        }
        if (this.tryLock()) {
            try {
                NOptional<T> e = NOptional.of(callable.call());
                return e;
            }
            catch (Exception e) {
                NOptional nOptional = NOptional.ofError(NMsg.ofC("error call %s", e), (Throwable)e);
                return nOptional;
            }
            finally {
                this.unlock();
            }
        }
        return NOptional.ofEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> NOptional<T> callWith(Callable<T> callable, long time, TimeUnit unit) {
        NOptional<T> e2;
        if (this.isHeldByCurrentThread()) {
            this.relock();
            try {
                NOptional<T> nOptional = NOptional.of(callable.call());
                return nOptional;
            }
            catch (Exception e2) {
                NOptional nOptional = NOptional.ofError(NMsg.ofC("error call %s", e2), (Throwable)e2);
                return nOptional;
            }
            finally {
                this.reunlock();
            }
        }
        if (!this.tryLock(time, unit)) return NOptional.ofEmpty();
        try {
            e2 = NOptional.of(callable.call());
        }
        catch (Exception e3) {
            NOptional nOptional;
            try {
                nOptional = NOptional.ofError(NMsg.ofC("error call %s", e3), (Throwable)e3);
            }
            catch (Throwable throwable) {
                try {
                    this.unlock();
                    throw throwable;
                }
                catch (InterruptedException e4) {
                    return NOptional.ofError(NMsg.ofC("error call %s", e4), (Throwable)e4);
                }
            }
            this.unlock();
            return nOptional;
        }
        this.unlock();
        return e2;
    }

    protected abstract void reunlock();

    protected abstract void relock();
}

