/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.boot;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.core.NStoreStrategy;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.platform.NHomeLocation;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.standalone.workspace.config.DefaultNWorkspaceCurrentConfig;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NCollections;

public final class NBootConfig
implements Cloneable,
Serializable {
    private String name;
    private String workspace;
    private NVersion apiVersion;
    private NId runtimeId;
    private NDescriptor runtimeBootDescriptor;
    private List<NDescriptor> extensionBootDescriptors;
    private List<String> bootRepositories;
    private String javaCommand;
    private String javaOptions;
    private NStoreStrategy storeStrategy;
    private NStoreStrategy repositoryStoreStrategy;
    private NOsFamily storeLayout;
    private boolean system;
    private Map<NStoreType, String> storeLocations;
    private Map<NHomeLocation, String> homeLocations;

    public NBootConfig() {
    }

    public NBootConfig(NWorkspaceOptions options) {
        if (options != null) {
            this.setWorkspace(options.getWorkspace().orNull());
            this.setName(options.getName().orNull());
            this.setStoreStrategy(options.getStoreStrategy().orNull());
            this.setRepositoryStoreStrategy(options.getRepositoryStoreStrategy().orNull());
            this.setStoreLayout(options.getStoreLayout().orNull());
            this.storeLocations = NCollections.nonNullMap(options.getStoreLocations().orNull());
            this.homeLocations = NCollections.nonNullMap(options.getHomeLocations().orNull());
            this.setRuntimeId(options.getRuntimeId().orNull());
            this.system = options.getSystem().orElse(false);
            this.runtimeId = options.getRuntimeId().orNull();
        }
    }

    public NBootConfig(DefaultNWorkspaceCurrentConfig context) {
        if (context != null) {
            this.name = context.getName();
            this.apiVersion = context.getApiVersion();
            this.runtimeId = context.getRuntimeId();
            this.runtimeBootDescriptor = context.getRuntimeBootDescriptor();
            this.extensionBootDescriptors = context.getExtensionBootDescriptors();
            this.bootRepositories = context.getBootRepositories();
            this.javaCommand = context.getJavaCommand();
            this.javaOptions = context.getJavaOptions();
            this.storeLocations = new LinkedHashMap<NStoreType, String>(context.getStoreLocations());
            this.homeLocations = new LinkedHashMap<NHomeLocation, String>(context.getHomeLocations());
            this.storeStrategy = context.getStoreStrategy();
            this.repositoryStoreStrategy = context.getRepositoryStoreStrategy();
            this.storeLayout = context.getStoreLayout();
            this.system = context.getSystem();
        }
    }

    public NBootConfig(NBootConfig other) {
        if (other != null) {
            this.name = other.getName();
            this.apiVersion = other.getApiVersion();
            this.runtimeId = other.getRuntimeId();
            this.runtimeBootDescriptor = other.getRuntimeBootDescriptor();
            this.extensionBootDescriptors = other.getExtensionBootDescriptors();
            this.bootRepositories = other.getBootRepositories();
            this.javaCommand = other.getJavaCommand();
            this.javaOptions = other.getJavaOptions();
            this.storeLocations = other.storeLocations == null ? null : new LinkedHashMap<NStoreType, String>(other.storeLocations);
            this.homeLocations = other.homeLocations == null ? null : new LinkedHashMap<NHomeLocation, String>(other.homeLocations);
            this.storeStrategy = other.getStoreStrategy();
            this.storeLayout = other.getStoreLayout();
            this.system = other.isSystem();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NVersion getApiVersion() {
        return this.apiVersion;
    }

    public String getApiId() {
        return "net.thevpc.nuts:nuts#" + this.apiVersion;
    }

    public NBootConfig setApiVersion(NVersion apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public NId getRuntimeId() {
        return this.runtimeId;
    }

    public NBootConfig setRuntimeId(NId runtimeId) {
        this.runtimeId = runtimeId;
        return this;
    }

    public NDescriptor getRuntimeBootDescriptor() {
        return this.runtimeBootDescriptor;
    }

    public NBootConfig setRuntimeBootDescriptor(NDescriptor runtimeBootDescriptor) {
        this.runtimeBootDescriptor = runtimeBootDescriptor;
        return this;
    }

    public List<NDescriptor> getExtensionBootDescriptors() {
        return this.extensionBootDescriptors;
    }

    public NBootConfig setExtensionBootDescriptors(List<NDescriptor> extensionBootDescriptors) {
        this.extensionBootDescriptors = extensionBootDescriptors;
        return this;
    }

    public String getJavaCommand() {
        return this.javaCommand;
    }

    public NBootConfig setJavaCommand(String javaCommand) {
        this.javaCommand = javaCommand;
        return this;
    }

    public String getJavaOptions() {
        return this.javaOptions;
    }

    public NBootConfig setJavaOptions(String javaOptions) {
        this.javaOptions = javaOptions;
        return this;
    }

    public List<String> getBootRepositories() {
        return this.bootRepositories;
    }

    public NBootConfig setBootRepositories(List<String> repositories) {
        this.bootRepositories = repositories;
        return this;
    }

    public NBootConfig copy() {
        try {
            NBootConfig p = (NBootConfig)this.clone();
            p.storeLocations = p.storeLocations == null ? null : new LinkedHashMap<NStoreType, String>(p.storeLocations);
            p.homeLocations = p.homeLocations == null ? null : new LinkedHashMap<NHomeLocation, String>(p.homeLocations);
            return p;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public NStoreStrategy getStoreStrategy() {
        return this.storeStrategy;
    }

    public NBootConfig setStoreStrategy(NStoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
        return this;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public NBootConfig setWorkspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public NOsFamily getStoreLayout() {
        return this.storeLayout;
    }

    public void setStoreLocations(Map<NStoreType, String> storeLocations) {
        this.storeLocations = storeLocations;
    }

    public void setHomeLocations(Map<NHomeLocation, String> homeLocations) {
        this.homeLocations = homeLocations;
    }

    public NBootConfig setStoreLayout(NOsFamily storeLayout) {
        this.storeLayout = storeLayout;
        return this;
    }

    public NStoreStrategy getRepositoryStoreStrategy() {
        return this.repositoryStoreStrategy;
    }

    public NBootConfig setRepositoryStoreStrategy(NStoreStrategy repositoryStoreStrategy) {
        this.repositoryStoreStrategy = repositoryStoreStrategy;
        return this;
    }

    public Map<NStoreType, String> getStoreLocations() {
        return this.storeLocations;
    }

    public Map<NHomeLocation, String> getHomeLocations() {
        return this.homeLocations;
    }

    public boolean isSystem() {
        return this.system;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("NutsBootConfig{");
        if (!NBlankable.isBlank(this.apiVersion)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("apiVersion='").append(this.apiVersion).append('\'');
        }
        if (!NBlankable.isBlank(this.runtimeId)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("runtimeId='").append(this.runtimeId).append('\'');
        }
        if (this.runtimeBootDescriptor != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("runtimeDependencies=").append(this.runtimeBootDescriptor);
        }
        if (!NBlankable.isBlank(this.bootRepositories)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("bootRepositories='").append(this.bootRepositories).append('\'');
        }
        if (!NBlankable.isBlank(this.javaCommand)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("javaCommand='").append(this.javaCommand).append('\'');
        }
        if (!NBlankable.isBlank(this.javaOptions)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("javaOptions='").append(this.javaOptions).append('\'');
        }
        if (!NBlankable.isBlank(this.workspace)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("workspace='").append(this.workspace).append('\'');
        }
        if (this.storeLocations != null && !this.storeLocations.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLocations=").append(this.storeLocations);
        }
        if (this.homeLocations != null && !this.homeLocations.isEmpty()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("homeLocations=").append(this.homeLocations);
        }
        if (this.storeStrategy != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeStrategy=").append(this.storeStrategy);
        }
        if (this.repositoryStoreStrategy != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("repositoryStoreStrategy=").append(this.repositoryStoreStrategy);
        }
        if (this.storeLayout != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("storeLayout=").append(this.storeLayout);
        }
        if (this.system) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("global");
        }
        sb.append('}');
        return sb.toString();
    }
}

