/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.boot;

import java.io.Console;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.boot.NWorkspaceTerminalOptions;
import net.thevpc.nuts.cmdline.DefaultNArg;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NSystemTerminal;
import net.thevpc.nuts.io.NullNPrintStream;
import net.thevpc.nuts.io.NullOutputStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.runtime.optional.jansi.OptionalJansi;
import net.thevpc.nuts.runtime.standalone.boot.NBootModel;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNSystemTerminalBase;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNSystemTerminalBaseBoot;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNTerminalFromSystem;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultSystemTerminal;
import net.thevpc.nuts.runtime.standalone.io.terminal.NSystemTerminalRef;
import net.thevpc.nuts.runtime.standalone.session.DefaultNSession;
import net.thevpc.nuts.runtime.standalone.util.CorePlatformUtils;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspace;
import net.thevpc.nuts.runtime.standalone.workspace.NativeImageHelper;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceModel;
import net.thevpc.nuts.spi.NDefaultTerminalSpec;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.spi.NTerminalSpec;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;

public class DefaultNBootModel
implements NBootModel {
    public NPrintStream nullOut;
    public OutputStream nullOutputStream;
    protected NWorkspace workspace;
    protected boolean firstBoot;
    protected boolean initializing;
    protected NBootOptions bOptions;
    protected NBootOptions effOptions;
    protected NSession bootSession;
    private Map<String, NLiteral> customBootOptions;
    private NWorkspaceTerminalOptions bootTerminal;
    private NLog LOG;
    private NSystemTerminalRef systemTerminal;
    private NWorkspaceModel workspaceModel;

    public DefaultNBootModel(NWorkspace workspace, NWorkspaceModel workspaceModel, NBootOptions bOption0, NLog LOG) {
        this.workspace = workspace;
        this.LOG = LOG;
        this.workspaceModel = workspaceModel;
        this.bOptions = bOption0.readOnly();
        this.effOptions = bOption0.readOnly();
        this.bootSession = new DefaultNSession(workspace, null).copyFrom(this.effOptions);
    }

    public void init() {
        this.initializing = true;
        NativeImageHelper.prepare(this.workspace);
        this.bootTerminal = DefaultNBootModel.detectAnsiTerminalSupport(this.effOptions, true, ((DefaultNWorkspace)this.workspace).getModel().LOG);
        this.workspaceModel.uuid = this.effOptions.getUuid().orNull();
        String wsp = this.effOptions.getWorkspace().orNull();
        try {
            this.workspaceModel.name = NBlankable.isBlank(wsp) ? null : Paths.get(wsp, new String[0]).getFileName().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DefaultSystemTerminal sys = new DefaultSystemTerminal(new DefaultNSystemTerminalBaseBoot(this));
        this.systemTerminal = new NSystemTerminalRef(this.NutsSystemTerminal_of_NutsSystemTerminalBase(sys));
        this.bootSession.setTerminal(new DefaultNTerminalFromSystem(this.systemTerminal));
        this.nullOut = NullNPrintStream.INSTANCE;
        this.nullOutputStream = NullOutputStream.INSTANCE;
    }

    public static NWorkspaceTerminalOptions detectAnsiTerminalSupport(NBootOptions bOption, boolean boot, NLog log) {
        boolean noColor;
        Console console0;
        NOsFamily os = NOsFamily.getCurrent();
        LinkedHashSet<String> flags = new LinkedHashSet<String>();
        boolean tty = false;
        boolean customOut = false;
        boolean customErr = false;
        boolean customIn = false;
        InputStream stdIn = System.in;
        PrintStream stdOut = System.out;
        PrintStream stdErr = System.err;
        if (bOption.getStdin().isPresent() && bOption.getStdin().get() != System.in) {
            stdIn = bOption.getStdin().orNull();
            flags.add("customIn");
            customIn = true;
        }
        if (bOption.getStdout().isPresent() && bOption.getStdout().get() != System.out) {
            stdOut = bOption.getStdout().orNull();
            flags.add("customOut");
            customOut = true;
        }
        if (bOption.getStderr().isPresent() && bOption.getStderr().get() != System.err) {
            stdErr = bOption.getStderr().orNull();
            flags.add("customErr");
            customErr = true;
        }
        if ((console0 = System.console()) != null) {
            flags.add("console");
        }
        if (!customOut) {
            if (System.getenv("TERM") != null && !"dumb".equalsIgnoreCase(System.getenv("TERM"))) {
                flags.add("tty");
                tty = true;
            } else if (console0 != null) {
                flags.add("tty");
                tty = true;
            } else if (OptionalJansi.isAvailable() && OptionalJansi.isatty(1)) {
                flags.add("tty");
                tty = true;
            }
        }
        boolean supportsAnsi = false;
        boolean acceptAnsi = false;
        boolean denyAnsi = false;
        boolean bl = noColor = System.getenv("NO_COLOR") != null;
        if (noColor) {
            denyAnsi = true;
        }
        if (bOption.getTerminalMode().isPresent()) {
            switch (bOption.getTerminalMode().get()) {
                case FORMATTED: 
                case ANSI: {
                    acceptAnsi = true;
                    break;
                }
                case FILTERED: {
                    denyAnsi = true;
                }
            }
        }
        switch (os) {
            case LINUX: 
            case MACOS: 
            case UNIX: {
                if (!tty) break;
                supportsAnsi = true;
                break;
            }
            case WINDOWS: {
                if (!CorePlatformUtils.IS_CYGWIN && !CorePlatformUtils.IS_MINGW_XTERM) break;
                if (CorePlatformUtils.IS_CYGWIN) {
                    if (tty) {
                        supportsAnsi = true;
                    }
                    flags.add("cygwin");
                }
                if (!CorePlatformUtils.IS_MINGW_XTERM) break;
                if (tty) {
                    supportsAnsi = true;
                }
                flags.add("mingw");
            }
        }
        if (!denyAnsi) {
            OptionalJansi.fillAnsiFlags(flags);
            if (!flags.contains("ansi") && !flags.contains("raw")) {
                if (supportsAnsi) {
                    flags.add("ansi");
                } else {
                    flags.add("raw");
                }
            }
        } else if (!flags.contains("ansi") && !flags.contains("raw")) {
            flags.add("raw");
        }
        return new NWorkspaceTerminalOptions(stdIn, stdOut, stdErr, flags.toArray(new String[0]));
    }

    public void onInitializeWorkspace() {
        this.bootTerminal = DefaultNBootModel.detectAnsiTerminalSupport(this.effOptions, false, this.LOG);
    }

    public void setSystemTerminal(NSystemTerminalBase terminal) {
        this.systemTerminal.setBase(terminal);
    }

    public NSystemTerminal createSystemTerminal(NTerminalSpec spec) {
        NSystemTerminalBase termb = NExtensions.of().createComponent(NSystemTerminalBase.class, spec).get();
        return this.NutsSystemTerminal_of_NutsSystemTerminalBase(termb);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNBootModel.class);
    }

    public void enableRichTerm() {
        NSystemTerminal st = this.getSystemTerminal();
        if (!st.isAutoCompleteSupported()) {
            NId extId = NId.get("net.thevpc.nuts:nuts-term#" + this.workspace.getApiVersion()).get();
            if (!NExtensions.of().isExcludedExtension(extId.toString(), NWorkspace.of().getBootOptions().toWorkspaceOptions())) {
                NExtensions extensions = NExtensions.of();
                extensions.loadExtension(extId);
                NSystemTerminal systemTerminal = this.createSystemTerminal(new NDefaultTerminalSpec().setAutoComplete(true));
                this.setSystemTerminal(systemTerminal);
                if (this.getSystemTerminal().isAutoCompleteSupported()) {
                    this._LOG().log(NMsg.ofPlain("enable rich terminal").asFine().withIntent(NMsgIntent.SUCCESS));
                } else {
                    this._LOG().log(NMsg.ofPlain("unable to enable rich terminal").asFineFail());
                }
            } else {
                this._LOG().log(NMsg.ofPlain("enableRichTerm discarded; nuts-term is excluded.").asFineAlert());
            }
        }
    }

    private NSystemTerminal NutsSystemTerminal_of_NutsSystemTerminalBase(NSystemTerminalBase terminal) {
        NSystemTerminal syst;
        if (terminal == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("missing terminal"));
        }
        if (terminal instanceof NSystemTerminal) {
            syst = (NSystemTerminal)terminal;
        } else {
            try {
                syst = new DefaultSystemTerminal(terminal);
            }
            catch (Exception ex) {
                this._LOG().log(NMsg.ofC("unable to create system terminal : %s", ex).asFinestAlert());
                DefaultNSystemTerminalBase b = new DefaultNSystemTerminalBase(this.workspace);
                syst = new DefaultSystemTerminal(b);
            }
        }
        return syst;
    }

    public NBootOptions getBootEffectiveOptions() {
        return this.effOptions;
    }

    public NBootOptions getBootUserOptions() {
        return this.bOptions;
    }

    public NWorkspaceTerminalOptions getBootTerminal() {
        return this.bootTerminal;
    }

    @Override
    public boolean isInitializing() {
        return this.initializing;
    }

    public DefaultNBootModel setInitializing(boolean initializing) {
        this.initializing = initializing;
        return this;
    }

    @Override
    public boolean isFirstBoot() {
        return this.firstBoot;
    }

    public DefaultNBootModel setFirstBoot(boolean firstBoot) {
        this.firstBoot = firstBoot;
        return this;
    }

    @Override
    public NPrintStream nullPrintStream() {
        return this.nullOut;
    }

    public OutputStream nullOutputStream() {
        return this.nullOutputStream;
    }

    @Override
    public NSystemTerminal getSystemTerminal() {
        return this.systemTerminal;
    }

    public NSession bootSession() {
        return this.bootSession;
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    public NSession getBootSession() {
        return this.bootSession;
    }

    public NOptional<NLiteral> getCustomBootOption(String ... names) {
        for (String name : names) {
            NLiteral r = this.getCustomBootOptions().get(name);
            if (r == null) continue;
            return NOptional.of(r);
        }
        return NOptional.ofNamedEmpty("options " + Arrays.asList(names));
    }

    public NOptional<NLiteral> getCustomBootOption(String name) {
        NLiteral r = this.getCustomBootOptions().get(name);
        return NOptional.ofNamed(r, "option " + name);
    }

    public Map<String, NLiteral> getCustomBootOptions() {
        if (this.customBootOptions == null) {
            this.customBootOptions = new LinkedHashMap<String, NLiteral>();
            List<String> properties = this.bOptions.getCustomOptions().orNull();
            if (properties != null) {
                for (String property : properties) {
                    DefaultNArg a;
                    if (property == null || !(a = new DefaultNArg(property)).isUncommented()) continue;
                    String key = a.getKey().asString().orElse("");
                    String v = a.getStringValue().orElse(null);
                    if (a.isEnabled()) {
                        this.customBootOptions.put(key, NLiteral.of(v));
                        continue;
                    }
                    if (NBlankable.isBlank(v)) {
                        this.customBootOptions.put(key, NLiteral.of(false));
                        continue;
                    }
                    NOptional<Boolean> b = NLiteral.of(v).asBoolean();
                    if (b.isPresent()) {
                        this.customBootOptions.put(key, NLiteral.of(b.get() == false));
                        continue;
                    }
                    this.customBootOptions.put(key, NLiteral.of("!" + v));
                }
            }
        }
        return this.customBootOptions;
    }
}

