/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.gui;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import net.thevpc.nuts.Nuts;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTexts;

public final class CoreNUtilGui {
    private CoreNUtilGui() {
    }

    public static boolean isGraphicalDesktopEnvironment() {
        try {
            if (GraphicsEnvironment.isHeadless()) {
                return false;
            }
            try {
                GraphicsDevice[] screenDevices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
                if (screenDevices == null || screenDevices.length == 0) {
                    return false;
                }
            }
            catch (HeadlessException e) {
                return false;
            }
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static GuiResult inputString(NMsg message, NMsg title, boolean rememberMe) {
        try {
            String line;
            NTexts text = NTexts.of();
            if (title == null) {
                title = NMsg.ofC("Nuts Package Manager - %s", Nuts.getVersion());
            }
            if ((line = JOptionPane.showInputDialog(null, text.of(message).filteredText(), text.of(title).filteredText(), 3)) == null) {
                line = "";
            }
            if (rememberMe) {
                // empty if block
            }
            return new GuiResult(line, false);
        }
        catch (UnsatisfiedLinkError e) {
            NSession session = NSession.of();
            session.err().println(NMsg.ofC("[Graphical Environment Unsupported] %s", title));
            String line = session.getTerminal().readLine(NMsg.ofPlain(message.toString()));
            if (rememberMe) {
                // empty if block
            }
            return new GuiResult(line, false);
        }
    }

    public static GuiResult inputPassword(NMsg message, NMsg title, boolean rememberMe) {
        if (title == null) {
            title = NMsg.ofC("Nuts Package Manager - %s", Nuts.getVersion());
        }
        if (message == null) {
            message = NMsg.ofPlain("");
        }
        NTexts text = NTexts.of();
        String messageString = text.of(message).filteredText();
        String titleString = text.of(title).filteredText();
        try {
            JPanel panel = new JPanel();
            JLabel label = new JLabel(messageString);
            JPasswordField pass = new JPasswordField(10);
            panel.add(label);
            panel.add(pass);
            Object[] options = new String[]{"OK", "Cancel"};
            int option = JOptionPane.showOptionDialog(null, panel, titleString, 0, -1, null, options, options[1]);
            if (option == 0) {
                String string = new String(pass.getPassword());
                if (rememberMe) {
                    // empty if block
                }
                return new GuiResult(string, false);
            }
            if (rememberMe) {
                // empty if block
            }
            return new GuiResult("", false);
        }
        catch (UnsatisfiedLinkError e) {
            NSession session = NSession.of();
            session.err().println(NMsg.ofC("[Graphical Environment Unsupported] %s", title));
            String string = session.getTerminal().readLine(NMsg.ofPlain(message.toString()));
            if (rememberMe) {
                // empty if block
            }
            return new GuiResult(string, false);
        }
    }

    public static void showMessage(NMsg message, NMsg title) {
        if (title == null) {
            title = NMsg.ofC("Nuts Package Manager - %s", Nuts.getVersion());
        }
        NTexts text = NTexts.of();
        String messageString = text.of(message == null ? "" : message).filteredText();
        String titleString = text.of(title).filteredText();
        try {
            JOptionPane.showMessageDialog(null, messageString, titleString, 3);
        }
        catch (UnsatisfiedLinkError e) {
            NSession session = NSession.of();
            session.err().println(NMsg.ofC("[Graphical Environment Unsupported] %s", title));
        }
    }

    public static class GuiResult {
        Object value;
        boolean rememberMe;

        public GuiResult(Object value, boolean rememberMe) {
            this.value = value;
            this.rememberMe = rememberMe;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isRememberMe() {
            return this.rememberMe;
        }
    }
}

