/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline.option;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.cmdline.DefaultNArgCandidate;
import net.thevpc.nuts.cmdline.NArgCandidate;
import net.thevpc.nuts.cmdline.NCmdLineAutoComplete;
import net.thevpc.nuts.core.NConstants;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.DefaultNonOption;
import net.thevpc.nuts.security.NUser;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;

public class PermissionNonOption
extends DefaultNonOption {
    private final boolean existing;
    private final String user;

    public PermissionNonOption(String name, String user, boolean existing) {
        super(name);
        this.existing = existing;
        this.user = user;
    }

    @Override
    public List<NArgCandidate> getCandidates(NCmdLineAutoComplete context) {
        ArrayList<NArgCandidate> all = new ArrayList<NArgCandidate>();
        for (String r : NConstants.Permissions.ALL) {
            all.add(new DefaultNArgCandidate(r));
        }
        Iterator i = all.iterator();
        NRepository repository = context.get(NRepository.class);
        NUser info = repository != null ? repository.security().getEffectiveUser(this.user) : NWorkspaceSecurityManager.of().findUser(this.user);
        HashSet rights = new HashSet(info == null ? Collections.emptyList() : info.getPermissions());
        while (i.hasNext()) {
            NArgCandidate right = (NArgCandidate)i.next();
            if (this.existing) {
                if (rights.contains(right.getValue())) continue;
                i.remove();
                continue;
            }
            if (!rights.contains(right.getValue())) continue;
            i.remove();
        }
        return all;
    }
}

