/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline.option;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.cmdline.DefaultNArgCandidate;
import net.thevpc.nuts.cmdline.NArgCandidate;
import net.thevpc.nuts.cmdline.NCmdLineAutoComplete;
import net.thevpc.nuts.core.NRepository;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.DefaultNonOption;
import net.thevpc.nuts.security.NUser;
import net.thevpc.nuts.security.NUserConfig;
import net.thevpc.nuts.security.NWorkspaceSecurityManager;

public class GroupNonOption
extends DefaultNonOption {
    public GroupNonOption(String name) {
        super(name);
    }

    @Override
    public List<NArgCandidate> getCandidates(NCmdLineAutoComplete context) {
        ArrayList<NArgCandidate> all = new ArrayList<NArgCandidate>();
        NRepository repository = context.get(NRepository.class);
        NUserConfig securityEntityConfig = context.get(NUserConfig.class);
        if (securityEntityConfig != null) {
            for (String n : securityEntityConfig.getGroups()) {
                all.add(new DefaultNArgCandidate(n));
            }
        } else if (repository != null) {
            for (NUser nutsSecurityEntityConfig : repository.security().findUsers()) {
                all.add(new DefaultNArgCandidate(nutsSecurityEntityConfig.getUser()));
            }
        } else {
            for (NUser nutsSecurityEntityConfig : NWorkspaceSecurityManager.of().findUsers()) {
                all.add(new DefaultNArgCandidate(nutsSecurityEntityConfig.getUser()));
            }
        }
        return all;
    }
}

