/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline;

import java.util.ArrayList;
import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.text.NMsg;

public class NCmdLineUtils {
    public static OptionsAndArgs parseOptionsFirst(String[] args) {
        int i;
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> nonOptions = new ArrayList<String>();
        for (i = 0; i < args.length && args[i].startsWith("-"); ++i) {
            options.add(args[i]);
        }
        while (i < args.length) {
            nonOptions.add(args[i]);
            ++i;
        }
        return new OptionsAndArgs(options.toArray(new String[0]), nonOptions.toArray(new String[0]));
    }

    public static String escapeArguments(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(NCmdLineUtils.escapeArgument(arg));
        }
        return sb.toString();
    }

    public static String escapeArgument(String arg) {
        StringBuilder sb = new StringBuilder();
        if (arg != null) {
            block9: for (char c : arg.toCharArray()) {
                switch (c) {
                    case '\\': {
                        sb.append('\\');
                        continue block9;
                    }
                    case '\'': {
                        sb.append("\\'");
                        continue block9;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block9;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block9;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block9;
                    }
                    case '\r': {
                        sb.append("\\r");
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block9;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
        }
        return sb.toString();
    }

    public static String[] parseCmdLine(String commandLineString) {
        if (commandLineString == null) {
            return new String[0];
        }
        ArrayList<String> args = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean START = false;
        boolean IN_WORD = true;
        int IN_QUOTED_WORD = 2;
        int IN_DBQUOTED_WORD = 3;
        int status = 0;
        char[] charArray = commandLineString.toCharArray();
        block30: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (status) {
                case 0: {
                    switch (c) {
                        case ' ': {
                            continue block30;
                        }
                        case '\'': {
                            status = 2;
                            continue block30;
                        }
                        case '\"': {
                            status = 3;
                            continue block30;
                        }
                        case '\\': {
                            status = 1;
                            sb.append(charArray[++i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    status = 1;
                    continue block30;
                }
                case 1: {
                    switch (c) {
                        case ' ': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\'': {
                            throw new NParseException(NMsg.ofC("illegal char %s", Character.valueOf(c)));
                        }
                        case '\"': {
                            throw new NParseException(NMsg.ofC("illegal char %s", Character.valueOf(c)));
                        }
                        case '\\': {
                            sb.append(charArray[++i]);
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                    }
                    sb.append(c);
                    continue block30;
                }
                case 3: {
                    switch (c) {
                        case '\"': {
                            args.add(sb.toString());
                            sb.delete(0, sb.length());
                            status = 0;
                            continue block30;
                        }
                        case '\\': {
                            i = NCmdLineUtils.readEscaped(charArray, i + 1, sb);
                            continue block30;
                        }
                    }
                    sb.append(c);
                }
            }
        }
        switch (status) {
            case 0: {
                break;
            }
            case 1: {
                args.add(sb.toString());
                sb.delete(0, sb.length());
                break;
            }
            case 2: {
                throw new NParseException(NMsg.ofPlain("expected '"));
            }
        }
        return args.toArray(new String[0]);
    }

    public static int readEscaped(char[] charArray, int i, StringBuilder sb) {
        char c = charArray[i];
        switch (c) {
            case 'n': {
                sb.append('\n');
                break;
            }
            case 't': {
                sb.append('\t');
                break;
            }
            case 'r': {
                sb.append('\r');
                break;
            }
            case 'f': {
                sb.append('\f');
                break;
            }
            default: {
                sb.append(c);
            }
        }
        return i;
    }

    public static class OptionsAndArgs {
        private String[] options;
        private String[] args;

        public OptionsAndArgs(String[] options, String[] args) {
            this.options = options;
            this.args = args;
        }

        public String[] getOptions() {
            return this.options;
        }

        public String[] getArgs() {
            return this.args;
        }
    }
}

