/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.app.cmdline;

import net.thevpc.nuts.cmdline.DefaultNCmdLine;
import net.thevpc.nuts.cmdline.NArgName;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLines;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.ArchitectureNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.DefaultNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.ExtensionNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.FileNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.GroupNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.PackagingNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.PermissionNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.RepositoryNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.RepositoryTypeNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.UserNonOption;
import net.thevpc.nuts.runtime.standalone.app.cmdline.option.ValueNonOption;
import net.thevpc.nuts.runtime.standalone.xtra.shell.NShellHelper;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNCmdLines
implements NCmdLines {
    private NShellFamily family = NShellFamily.getCurrent();
    private boolean lenient;

    @Override
    public boolean isLenient() {
        return this.lenient;
    }

    @Override
    public NCmdLines setLenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    @Override
    public NShellFamily getShellFamily() {
        return this.family;
    }

    @Override
    public NCmdLines setShellFamily(NShellFamily family) {
        this.family = family == null ? NShellFamily.getCurrent() : family;
        return this;
    }

    @Override
    public NOptional<NCmdLine> parseCmdLine(String line) {
        try {
            return NOptional.of(new DefaultNCmdLine(this.parseCmdLineArr(line), this.family));
        }
        catch (Exception e) {
            return NOptional.ofNamedError(NMsg.ofC("%s", e));
        }
    }

    @Override
    public NCmdLine of(String[] args) {
        return new DefaultNCmdLine(args, this.family);
    }

    private String[] parseCmdLineArr(String line) {
        NShellFamily f = this.getShellFamily();
        if (f == null) {
            f = NWorkspace.of().getShellFamily();
        }
        if (f == null) {
            f = NShellFamily.getCurrent();
        }
        return NShellHelper.of(f).parseCmdLineArr(line, this.lenient);
    }

    @Override
    public NArgName createName(String type, String label) {
        return Factory.createName0(type, label);
    }

    @Override
    public NArgName createName(String type) {
        return this.createName(type, type);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    public static class Factory {
        public static NArgName createName0(String type, String label) {
            if (type == null) {
                type = "";
            }
            if (label == null) {
                label = type;
            }
            switch (type) {
                case "arch": {
                    return new ArchitectureNonOption(label);
                }
                case "packaging": {
                    return new PackagingNonOption(label);
                }
                case "extension": {
                    return new ExtensionNonOption(type);
                }
                case "file": {
                    return new FileNonOption(type);
                }
                case "boolean": {
                    return new ValueNonOption(type, "true", "false");
                }
                case "repository": {
                    return new RepositoryNonOption(label);
                }
                case "repository-type": {
                    return new RepositoryTypeNonOption(label);
                }
                case "right": {
                    return new PermissionNonOption(label, null, false);
                }
                case "user": {
                    return new UserNonOption(label);
                }
                case "group": {
                    return new GroupNonOption(label);
                }
            }
            return new DefaultNonOption(label);
        }
    }
}

