/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import net.thevpc.nuts.artifact.NDescriptorProperty;
import net.thevpc.nuts.artifact.NDescriptorPropertyBuilder;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NEnvConditionBuilder;
import net.thevpc.nuts.boot.NBootDescriptorProperty;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorProperty;
import net.thevpc.nuts.runtime.standalone.DefaultNEnvConditionBuilder;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;

public class DefaultNDescriptorPropertyBuilder
implements NDescriptorPropertyBuilder {
    private static final long serialVersionUID = 1L;
    private String name;
    private NLiteral value = NLiteral.of(null);
    private NEnvConditionBuilder condition = new DefaultNEnvConditionBuilder();

    public DefaultNDescriptorPropertyBuilder() {
    }

    public DefaultNDescriptorPropertyBuilder(NDescriptorProperty other) {
        this.copyFrom(other);
    }

    public DefaultNDescriptorPropertyBuilder(NDescriptorPropertyBuilder other) {
        this.copyFrom(other);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NLiteral getValue() {
        return this.value;
    }

    @Override
    public NDescriptorPropertyBuilder setCondition(NEnvCondition condition) {
        this.condition.clear();
        this.condition.copyFrom(condition);
        return this;
    }

    @Override
    public NDescriptorPropertyBuilder setCondition(NEnvConditionBuilder condition) {
        this.condition.clear();
        this.condition.copyFrom(condition);
        return this;
    }

    @Override
    public NEnvConditionBuilder getCondition() {
        return this.condition;
    }

    @Override
    public NDescriptorPropertyBuilder setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public NDescriptorPropertyBuilder setValue(String value) {
        this.value = NLiteral.of(value);
        return this;
    }

    @Override
    public NDescriptorPropertyBuilder copyFrom(NDescriptorProperty value) {
        if (value == null) {
            this.setName(null);
            this.setValue(null);
            this.setCondition((NEnvCondition)null);
        } else {
            this.setName(value.getName());
            this.setValue(value.getValue().asString().orNull());
            this.setCondition(value.getCondition());
        }
        return this;
    }

    @Override
    public NDescriptorPropertyBuilder copyFrom(NDescriptorPropertyBuilder value) {
        if (value == null) {
            this.setName(null);
            this.setValue(null);
            this.setCondition((NEnvCondition)null);
        } else {
            this.setName(value.getName());
            this.setValue(value.getValue().asString().orNull());
            this.setCondition(value.getCondition());
        }
        return this;
    }

    public NDescriptorPropertyBuilder copyFrom(NBootDescriptorProperty value) {
        if (value == null) {
            this.setName(null);
            this.setValue(null);
            this.setCondition((NEnvCondition)null);
        } else {
            this.setName(value.getName());
            this.setValue(value.getValue());
            this.setCondition(value.getCondition() == null ? null : new DefaultNEnvConditionBuilder().copyFrom(value.getCondition()).build());
        }
        return this;
    }

    @Override
    public boolean isBlank() {
        if (!NBlankable.isBlank(this.name)) {
            return false;
        }
        if (!NBlankable.isBlank(this.value)) {
            return false;
        }
        return NBlankable.isBlank(this.condition);
    }

    public NDescriptorPropertyBuilder builder() {
        return new DefaultNDescriptorPropertyBuilder(this);
    }

    @Override
    public NDescriptorProperty build() {
        return new DefaultNDescriptorProperty(this.getName(), this.getValue(), this.getCondition().build());
    }

    @Override
    public NDescriptorPropertyBuilder copy() {
        return this.builder();
    }
}

