/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.Objects;
import net.thevpc.nuts.artifact.NDescriptorProperty;
import net.thevpc.nuts.artifact.NDescriptorPropertyBuilder;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorPropertyBuilder;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;

public class DefaultNDescriptorProperty
implements NDescriptorProperty {
    private final String name;
    private final NLiteral value;
    private final NEnvCondition condition;

    public static DefaultNDescriptorProperty of(String name, Object value) {
        return new DefaultNDescriptorProperty(name, NLiteral.of(value), NEnvCondition.BLANK);
    }

    public DefaultNDescriptorProperty(String name, NLiteral value, NEnvCondition condition) {
        this.name = name;
        this.value = value;
        this.condition = condition == null ? NEnvCondition.BLANK : condition;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NLiteral getValue() {
        return this.value;
    }

    @Override
    public NEnvCondition getCondition() {
        return this.condition;
    }

    @Override
    public NDescriptorPropertyBuilder builder() {
        return new DefaultNDescriptorPropertyBuilder().setName(this.getName()).setValue(this.getValue().asString().orNull()).setCondition(this.getCondition());
    }

    @Override
    public boolean isBlank() {
        if (!NBlankable.isBlank(this.name)) {
            return false;
        }
        if (!NBlankable.isBlank(this.value)) {
            return false;
        }
        return NBlankable.isBlank(this.condition);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.condition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNDescriptorProperty that = (DefaultNDescriptorProperty)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.condition, that.condition);
    }

    public String toString() {
        return this.name + "=" + this.value + (this.condition.isBlank() ? "" : " when " + this.condition);
    }
}

