/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorBuilder;
import net.thevpc.nuts.artifact.NDescriptorContributor;
import net.thevpc.nuts.artifact.NDescriptorFlag;
import net.thevpc.nuts.artifact.NDescriptorLicense;
import net.thevpc.nuts.artifact.NDescriptorMailingList;
import net.thevpc.nuts.artifact.NDescriptorOrganization;
import net.thevpc.nuts.artifact.NDescriptorProperty;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NEnvConditionBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdLocation;
import net.thevpc.nuts.artifact.NIdType;
import net.thevpc.nuts.boot.NBootDependency;
import net.thevpc.nuts.boot.NBootDescriptor;
import net.thevpc.nuts.boot.NBootDescriptorProperty;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNDependencyBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptor;
import net.thevpc.nuts.runtime.standalone.DefaultNDescriptorPropertyBuilder;
import net.thevpc.nuts.runtime.standalone.DefaultNEnvConditionBuilder;
import net.thevpc.nuts.util.DefaultNProperties;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNDescriptorBuilder
implements NDescriptorBuilder {
    private static final long serialVersionUID = 1L;
    private NId id;
    private List<NId> parents = new ArrayList<NId>();
    private NIdType idType = NIdType.REGULAR;
    private String packaging;
    private NArtifactCall executor;
    private NArtifactCall installer;
    private String name;
    private List<String> icons = new ArrayList<String>();
    private List<String> categories;
    private String genericName;
    private String description;
    private String solver;
    private NEnvConditionBuilder condition;
    private List<NIdLocation> locations = new ArrayList<NIdLocation>();
    private List<NDependency> dependencies = new ArrayList<NDependency>();
    private List<NDependency> standardDependencies = new ArrayList<NDependency>();
    private Set<NDescriptorFlag> flags = new LinkedHashSet<NDescriptorFlag>();
    private List<NDescriptorProperty> properties = new ArrayList<NDescriptorProperty>();
    private transient DefaultNProperties _propertiesBuilder = new DefaultNProperties();
    private List<NDescriptorContributor> contributors = new ArrayList<NDescriptorContributor>();
    private List<NDescriptorContributor> developers = new ArrayList<NDescriptorContributor>();
    private List<NDescriptorLicense> licenses = new ArrayList<NDescriptorLicense>();
    private List<NDescriptorMailingList> mailingLists = new ArrayList<NDescriptorMailingList>();
    private NDescriptorOrganization organization;

    public DefaultNDescriptorBuilder() {
        this.condition = new DefaultNEnvConditionBuilder();
    }

    public DefaultNDescriptorBuilder(NDescriptor other) {
        this.condition = new DefaultNEnvConditionBuilder();
        this.copyFrom(other);
    }

    public DefaultNDescriptorBuilder(NDescriptorBuilder other) {
        this.condition = new DefaultNEnvConditionBuilder();
        this.copyFrom(other);
    }

    @Override
    public NId getId() {
        return this.id;
    }

    @Override
    public NDescriptorBuilder setId(NId id) {
        this.id = id;
        return this;
    }

    @Override
    public NDescriptorBuilder setId(String id) {
        this.id = NId.get(id).get();
        return this;
    }

    @Override
    public List<NId> getParents() {
        return this.parents;
    }

    @Override
    public NDescriptorBuilder setParents(List<NId> parents) {
        this.parents = NReservedLangUtils.uniqueNonBlankList(parents);
        return this;
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public NDescriptorBuilder setPackaging(String packaging) {
        this.packaging = NStringUtils.trim(packaging);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NDescriptorBuilder setName(String name) {
        this.name = NStringUtils.trim(name);
        return this;
    }

    @Override
    public String getSolver() {
        return this.solver;
    }

    @Override
    public NDescriptorBuilder setSolver(String solver) {
        this.solver = solver;
        return this;
    }

    @Override
    public String getGenericName() {
        return this.genericName;
    }

    @Override
    public NDescriptorBuilder setGenericName(String name) {
        this.genericName = name;
        return this;
    }

    @Override
    public List<String> getIcons() {
        return this.icons;
    }

    @Override
    public NDescriptorBuilder setIcons(List<String> icons) {
        this.setIcons(icons == null ? null : icons.toArray(new String[0]));
        return this;
    }

    @Override
    public NDescriptorBuilder setIcons(String ... icons) {
        this.icons = new ArrayList<String>();
        if (icons != null) {
            for (String icon : icons) {
                if (NBlankable.isBlank(icon)) continue;
                this.icons.add(icon);
            }
        }
        return this;
    }

    @Override
    public NDescriptorBuilder setLocations(NIdLocation ... locations) {
        this.locations = new ArrayList<NIdLocation>();
        if (locations != null) {
            for (NIdLocation location : locations) {
                if (NBlankable.isBlank(location)) continue;
                this.locations.add(location);
            }
        }
        this.locations = NReservedLangUtils.uniqueList(this.locations);
        return this;
    }

    @Override
    public List<String> getCategories() {
        return this.categories;
    }

    @Override
    public NDescriptorBuilder setCategories(List<String> categories) {
        this.setCategories(categories == null ? null : categories.toArray(new String[0]));
        return this;
    }

    @Override
    public NDescriptorBuilder setCategories(String ... categories) {
        this.categories = new ArrayList<String>();
        if (categories != null) {
            for (String cat : categories) {
                if (NBlankable.isBlank(cat)) continue;
                this.categories.add(cat);
            }
        }
        return this;
    }

    @Override
    public NEnvConditionBuilder getCondition() {
        return this.condition;
    }

    @Override
    public NDescriptorBuilder setCondition(NEnvCondition condition) {
        this.condition.copyFrom(condition);
        return this;
    }

    @Override
    public NDescriptorBuilder setCondition(NEnvConditionBuilder condition) {
        this.condition.copyFrom(condition);
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public NDescriptorBuilder setDescription(String description) {
        this.description = NStringUtils.trim(description);
        return this;
    }

    @Override
    public List<NIdLocation> getLocations() {
        return this.locations;
    }

    @Override
    public NDescriptorBuilder setLocations(List<NIdLocation> locations) {
        this.setLocations(locations == null ? null : locations.toArray(new NIdLocation[0]));
        return this;
    }

    @Override
    public List<NDependency> getStandardDependencies() {
        return this.standardDependencies;
    }

    @Override
    public NDescriptorBuilder setStandardDependencies(List<NDependency> dependencies) {
        this.standardDependencies = NReservedLangUtils.uniqueNonBlankList(dependencies);
        return this;
    }

    @Override
    public List<NDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public NDescriptorBuilder setDependencies(List<NDependency> dependencies) {
        this.dependencies = NReservedLangUtils.uniqueNonBlankList(dependencies);
        return this;
    }

    @Override
    public NArtifactCall getExecutor() {
        return this.executor;
    }

    @Override
    public NDescriptorBuilder setExecutor(NArtifactCall executor) {
        this.executor = executor;
        return this;
    }

    @Override
    public NArtifactCall getInstaller() {
        return this.installer;
    }

    @Override
    public NDescriptorBuilder setInstaller(NArtifactCall installer) {
        this.installer = installer;
        return this;
    }

    @Override
    public List<NDescriptorProperty> getProperties() {
        return this.properties;
    }

    @Override
    public NDescriptorBuilder setProperties(List<NDescriptorProperty> properties) {
        this._rebuildPropertiesBuilder();
        this._propertiesBuilder.clear();
        if (properties != null && !properties.isEmpty()) {
            this._propertiesBuilder.addAll(properties);
        }
        this._updateProperties();
        return this;
    }

    @Override
    public NDescriptorBuilder addLocation(NIdLocation location) {
        if (this.locations == null) {
            this.locations = new ArrayList<NIdLocation>();
        }
        this.locations.add(location);
        return this;
    }

    @Override
    public NDescriptorBuilder setProperty(String name, String value) {
        NDescriptorProperty pp = new DefaultNDescriptorPropertyBuilder().setName(name).setValue(value).build();
        this._rebuildPropertiesBuilder();
        if (value == null) {
            this._propertiesBuilder.remove(pp);
        } else {
            this.properties.add(pp);
        }
        this._updateProperties();
        return this;
    }

    @Override
    public NDescriptorBuilder copyFrom(NDescriptorBuilder other) {
        if (other != null) {
            this.setId(other.getId());
            this.setIdType(other.getIdType());
            this.setPackaging(other.getPackaging());
            this.setParents(other.getParents());
            this.setDescription(other.getDescription());
            this.setName(other.getName());
            this.setExecutor(other.getExecutor());
            this.setInstaller(other.getInstaller());
            this.setCondition(other.getCondition());
            this.setLocations(other.getLocations());
            this.setDependencies(other.getDependencies());
            this.setStandardDependencies(other.getStandardDependencies());
            this.setProperties(other.getProperties());
            this.setIcons(new ArrayList<String>(other.getIcons()));
            this.setCategories(other.getCategories());
            this.setGenericName(other.getGenericName());
            this.setSolver(other.getSolver());
            this.setFlags(other.getFlags());
        } else {
            this.clear();
        }
        return this;
    }

    public NDescriptorBuilder copyFrom(NBootDescriptor other) {
        if (other != null) {
            this.setId(other.getId() == null ? null : NId.get(other.getId().toString()).get());
            this.setPackaging(other.getPackaging());
            this.setParents(other.getParents() == null ? null : other.getParents().stream().map(x -> NId.get(x.toString()).get()).collect(Collectors.toList()));
            this.setDescription(other.getDescription());
            this.setName(other.getName());
            this.setCondition(other.getCondition() == null ? null : new DefaultNEnvConditionBuilder().copyFrom(other.getCondition()).build());
            this.setDependencies(other.getDependencies() == null ? null : other.getDependencies().stream().map(x -> new DefaultNDependencyBuilder().copyFrom((NBootDependency)x).build()).collect(Collectors.toList()));
            this.setStandardDependencies(other.getStandardDependencies() == null ? null : other.getDependencies().stream().map(x -> new DefaultNDependencyBuilder().copyFrom((NBootDependency)x).build()).collect(Collectors.toList()));
            this.setProperties(other.getProperties() == null ? null : other.getProperties().stream().map(x -> new DefaultNDescriptorPropertyBuilder().copyFrom((NBootDescriptorProperty)x).build()).collect(Collectors.toList()));
            this.setIdType(null);
            this.setExecutor(null);
            this.setInstaller(null);
            this.setLocations(new NIdLocation[0]);
            this.setIcons(new String[0]);
            this.setCategories(new String[0]);
            this.setGenericName(null);
            this.setSolver(null);
            this.setFlags(new NDescriptorFlag[0]);
        } else {
            this.clear();
        }
        return this;
    }

    @Override
    public NDescriptorBuilder copyFrom(NDescriptor other) {
        if (other != null) {
            this.setId(other.getId());
            this.setIdType(other.getIdType());
            this.setPackaging(other.getPackaging());
            this.setParents(other.getParents());
            this.setDescription(other.getDescription());
            this.setName(other.getName());
            this.setExecutor(other.getExecutor());
            this.setInstaller(other.getInstaller());
            this.setCondition(other.getCondition());
            this.setLocations(other.getLocations());
            this.setDependencies(other.getDependencies());
            this.setStandardDependencies(other.getStandardDependencies());
            this.setProperties(other.getProperties());
            this.setIcons(other.getIcons());
            this.setGenericName(other.getGenericName());
            this.setCategories(other.getCategories());
            this.setSolver(other.getSolver());
            this.setFlags(other.getFlags());
            this.setOrganization(other.getOrganization());
            this.setContributors(other.getContributors());
            this.setDevelopers(other.getDevelopers());
            this.setLicenses(other.getLicenses());
            this.setMailingLists(other.getMailingLists());
        } else {
            this.clear();
        }
        return this;
    }

    @Override
    public NDescriptorBuilder clear() {
        this.setId((NId)null);
        this.setIdType(null);
        this.setPackaging(null);
        this.setParents(null);
        this.setDescription(null);
        this.setFlags(new LinkedHashSet<NDescriptorFlag>());
        this.setName(null);
        this.setExecutor(null);
        this.setInstaller(null);
        this.setCondition((NEnvCondition)null);
        this.setLocations(new NIdLocation[0]);
        this.setDependencies(null);
        this.setStandardDependencies(null);
        this.setProperties(null);
        this.setIcons(new String[0]);
        this.setCategories(new String[0]);
        this.setGenericName(null);
        this.setSolver(null);
        this.setOrganization(null);
        this.setContributors(null);
        this.setLicenses(null);
        this.setDevelopers(null);
        this.setMailingLists(null);
        return this;
    }

    @Override
    public NDescriptorBuilder removeDependency(NDependency dependency) {
        if (this.dependencies != null) {
            this.dependencies.remove(dependency);
        }
        return this;
    }

    @Override
    public NDescriptorBuilder addDependency(NDependency dependency) {
        if (!NBlankable.isBlank(dependency)) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<NDependency>();
            }
            this.dependencies.add(dependency);
        }
        return this;
    }

    @Override
    public NDescriptorBuilder addDependencies(List<NDependency> dependencies) {
        NReservedLangUtils.addUniqueNonBlankList(this.dependencies, dependencies);
        return this;
    }

    @Override
    public NDescriptorBuilder removeStandardDependency(NDependency dependency) {
        if (this.standardDependencies != null) {
            this.standardDependencies.remove(dependency);
        }
        return this;
    }

    @Override
    public NDescriptorBuilder addStandardDependency(NDependency dependency) {
        this.standardDependencies.add(dependency);
        return this;
    }

    @Override
    public NDescriptorBuilder addStandardDependencies(List<NDependency> dependencies) {
        NReservedLangUtils.addUniqueNonBlankList(this.standardDependencies, dependencies);
        return this;
    }

    @Override
    public NDescriptorBuilder addProperty(NDescriptorProperty property) {
        this._rebuildPropertiesBuilder();
        this._propertiesBuilder.add(property);
        this._updateProperties();
        return this;
    }

    @Override
    public NDescriptorBuilder removeProperties(NDescriptorProperty property) {
        this._rebuildPropertiesBuilder();
        this._propertiesBuilder.remove(property);
        this._updateProperties();
        return this;
    }

    @Override
    public NDescriptorBuilder addProperties(List<NDescriptorProperty> properties) {
        if (properties != null && properties.size() != 0) {
            this._rebuildPropertiesBuilder();
            this._propertiesBuilder.addAll(properties);
            this._updateProperties();
        }
        return this;
    }

    @Override
    public NDescriptorBuilder replaceProperty(Predicate<NDescriptorProperty> filter, Function<NDescriptorProperty, NDescriptorProperty> converter) {
        if (converter == null) {
            return this;
        }
        DefaultNProperties p = new DefaultNProperties();
        boolean someUpdate = false;
        for (NDescriptorProperty entry : this.getProperties()) {
            if (filter != null && !filter.test(entry)) continue;
            NDescriptorProperty v = converter.apply(entry);
            if (v != null) {
                if (!Objects.equals(v, entry)) {
                    someUpdate = true;
                }
                p.add(v);
                continue;
            }
            someUpdate = true;
        }
        if (someUpdate) {
            this.setProperties(p.toList());
        }
        return this;
    }

    @Override
    public NDescriptorBuilder replaceDependency(Predicate<NDependency> filter, UnaryOperator<NDependency> converter) {
        if (converter == null) {
            return this;
        }
        ArrayList<NDependency> dependenciesList = new ArrayList<NDependency>();
        for (NDependency d : this.getDependencies()) {
            if (filter == null || filter.test(d)) {
                if ((d = (NDependency)converter.apply(d)) == null) continue;
                dependenciesList.add(d);
                continue;
            }
            dependenciesList.add(d);
        }
        this.dependencies = dependenciesList;
        return this;
    }

    @Override
    public NDescriptorBuilder removeDependency(Predicate<NDependency> dependency) {
        if (dependency == null) {
            return this;
        }
        Iterator<NDependency> it = this.dependencies.iterator();
        while (it.hasNext()) {
            NDependency d = it.next();
            if (!dependency.test(d)) continue;
            it.remove();
        }
        return this;
    }

    @Override
    public NDescriptor build() {
        LinkedHashSet<NDescriptorFlag> flags = new LinkedHashSet<NDescriptorFlag>();
        NIdType idType = this.getIdType();
        for (NDescriptorProperty property : this.getProperties()) {
            if (!NBlankable.isBlank(property.getCondition())) continue;
            switch (property.getName()) {
                case "nuts.application": {
                    if (!property.getValue().asBoolean().orElse(false).booleanValue()) break;
                    flags.add(NDescriptorFlag.NUTS_APP);
                    flags.add(NDescriptorFlag.EXEC);
                    break;
                }
                case "nuts.executable": {
                    if (!property.getValue().asBoolean().orElse(false).booleanValue()) break;
                    flags.add(NDescriptorFlag.EXEC);
                    break;
                }
                case "nuts.term": {
                    if (!property.getValue().asBoolean().orElse(false).booleanValue()) break;
                    flags.add(NDescriptorFlag.TERM);
                    break;
                }
                case "nuts.gui": {
                    if (!property.getValue().asBoolean().orElse(false).booleanValue()) break;
                    flags.add(NDescriptorFlag.GUI);
                    break;
                }
                case "nuts.extension": {
                    if (!property.getValue().asBoolean().orElse(false).booleanValue()) break;
                    idType = NIdType.EXTENSION;
                    break;
                }
                case "nuts.runtime": {
                    if (!property.getValue().asBoolean().orElse(false).booleanValue()) break;
                    idType = NIdType.RUNTIME;
                    break;
                }
                case "nuts.companion": {
                    if (!property.getValue().asBoolean().orElse(false).booleanValue()) break;
                    idType = NIdType.COMPANION;
                }
            }
        }
        if (Objects.equals(this.getId().getShortName(), "net.thevpc.nuts:nuts")) {
            idType = NIdType.API;
        }
        if (Objects.equals(this.getId().getShortName(), "net.thevpc.nuts:nuts-runtime")) {
            idType = NIdType.RUNTIME;
        }
        for (NDescriptorFlag flag : this.flags) {
            flags.add(flag);
            switch (flag) {
                case NUTS_APP: 
                case TERM: 
                case GUI: {
                    flags.add(NDescriptorFlag.EXEC);
                }
            }
        }
        return new DefaultNDescriptor(this.getId(), idType, this.getParents(), this.getPackaging(), this.getExecutor(), this.getInstaller(), this.getName(), this.getDescription(), this.getCondition().build(), this.getDependencies(), this.getStandardDependencies(), this.getLocations(), this.getProperties(), this.genericName, this.categories, this.icons, flags, this.getSolver(), this.getContributors(), this.getDevelopers(), this.getLicenses(), this.getMailingLists(), this.getOrganization());
    }

    @Override
    public NDescriptorBuilder copy() {
        return new DefaultNDescriptorBuilder().copyFrom(this);
    }

    @Override
    public Set<NDescriptorFlag> getFlags() {
        return this.flags;
    }

    @Override
    public NDescriptorBuilder setFlags(Set<NDescriptorFlag> flags) {
        this.flags = flags == null ? new LinkedHashSet<NDescriptorFlag>() : new LinkedHashSet<NDescriptorFlag>(flags);
        return this;
    }

    @Override
    public NDescriptorBuilder setFlags(NDescriptorFlag ... flags) {
        LinkedHashSet<NDescriptorFlag> nv = new LinkedHashSet<NDescriptorFlag>();
        if (flags != null) {
            for (NDescriptorFlag v : flags) {
                if (v == null) continue;
                nv.add(v);
            }
        }
        this.flags = nv;
        return this;
    }

    @Override
    public NDescriptorBuilder addFlag(NDescriptorFlag flag) {
        if (flag != null) {
            this.flags.add(flag);
        }
        return this;
    }

    @Override
    public NDescriptorBuilder addFlags(NDescriptorFlag ... flags) {
        if (flags != null) {
            for (NDescriptorFlag flag : flags) {
                if (flag == null) continue;
                this.flags.add(flag);
            }
        }
        return this;
    }

    @Override
    public NDescriptorBuilder removeFlag(NDescriptorFlag flag) {
        if (flag != null) {
            this.flags.remove(flag);
        }
        return this;
    }

    @Override
    public NDescriptorBuilder removeFlags(NDescriptorFlag ... flags) {
        if (flags != null) {
            for (NDescriptorFlag flag : flags) {
                if (flag == null) continue;
                this.flags.remove(flag);
            }
        }
        return this;
    }

    @Override
    public NOptional<NDescriptorProperty> getProperty(String name) {
        return NOptional.ofNamed((NDescriptorProperty)Arrays.stream(this._propertiesBuilder.toArray()).filter(x -> x.getName().equals(name)).findFirst().orElse(null), "property " + name);
    }

    @Override
    public NOptional<NLiteral> getPropertyValue(String name) {
        return this.getProperty(name).map(NDescriptorProperty::getValue);
    }

    @Override
    public NIdType getIdType() {
        return this.idType;
    }

    @Override
    public NDescriptorBuilder setIdType(NIdType idType) {
        this.idType = idType == null ? NIdType.REGULAR : idType;
        return this;
    }

    private void _rebuildPropertiesBuilder() {
        if (this._propertiesBuilder == null) {
            this._propertiesBuilder = new DefaultNProperties();
            this._propertiesBuilder.addAll(this.properties);
        }
    }

    private void _updateProperties() {
        this.properties.clear();
        this.properties.addAll(Arrays.asList(this._propertiesBuilder.toArray()));
    }

    public int hashCode() {
        return Objects.hash(this.id, this.idType, this.packaging, this.executor, this.installer, this.name, this.icons, this.categories, this.genericName, this.description, this.condition, this.locations, this.dependencies, this.standardDependencies, this.properties, this.flags, this.solver, this.parents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNDescriptorBuilder that = (DefaultNDescriptorBuilder)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.idType, that.idType) && Objects.equals(this.parents, that.parents) && Objects.equals(this.packaging, that.packaging) && Objects.equals(this.executor, that.executor) && Objects.equals(this.installer, that.installer) && Objects.equals(this.name, that.name) && Objects.equals(this.icons, that.icons) && Objects.equals(this.categories, that.categories) && Objects.equals(this.genericName, that.genericName) && Objects.equals(this.description, that.description) && Objects.equals(this.condition, that.condition) && Objects.equals(this.locations, that.locations) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.standardDependencies, that.standardDependencies) && Objects.equals(this.properties, that.properties) && Objects.equals(this.flags, that.flags) && Objects.equals(this.solver, that.solver);
    }

    @Override
    public NDescriptorBuilder builder() {
        return new DefaultNDescriptorBuilder(this);
    }

    @Override
    public boolean isBlank() {
        return this.build().isBlank();
    }

    @Override
    public boolean isExecutable() {
        return this.getFlags().contains(NDescriptorFlag.EXEC);
    }

    @Override
    public boolean isNutsApplication() {
        return this.getFlags().contains(NDescriptorFlag.NUTS_APP);
    }

    @Override
    public boolean isPlatformApplication() {
        return this.getFlags().contains(NDescriptorFlag.PLATFORM_APP);
    }

    @Override
    public List<NDescriptorContributor> getContributors() {
        return this.contributors;
    }

    @Override
    public NDescriptorBuilder setContributors(List<NDescriptorContributor> contributors) {
        this.contributors = NReservedLangUtils.uniqueList(contributors);
        return this;
    }

    @Override
    public NDescriptorBuilder setDevelopers(List<NDescriptorContributor> developers) {
        this.developers = NReservedLangUtils.uniqueList(developers);
        return this;
    }

    @Override
    public List<NDescriptorLicense> getLicenses() {
        return this.licenses;
    }

    @Override
    public NDescriptorBuilder setLicenses(List<NDescriptorLicense> licenses) {
        this.licenses = NReservedLangUtils.uniqueList(licenses);
        return this;
    }

    @Override
    public List<NDescriptorMailingList> getMailingLists() {
        return this.mailingLists;
    }

    @Override
    public NDescriptorBuilder setMailingLists(List<NDescriptorMailingList> mailingLists) {
        this.mailingLists = NReservedLangUtils.uniqueList(mailingLists);
        return this;
    }

    @Override
    public NDescriptorOrganization getOrganization() {
        return this.organization;
    }

    @Override
    public NDescriptorBuilder setOrganization(NDescriptorOrganization organization) {
        this.organization = organization;
        return this;
    }

    @Override
    public List<NDescriptorContributor> getDevelopers() {
        return this.developers;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public boolean isNoContent() {
        return "pom".equals(this.getPackaging());
    }
}

