/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyBuilder;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NEnvConditionBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.boot.NBootDependency;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.runtime.standalone.DefaultNDependency;
import net.thevpc.nuts.runtime.standalone.DefaultNEnvConditionBuilder;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringMapFormat;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNDependencyBuilder
implements NDependencyBuilder {
    private String repo;
    private String groupId;
    private String artifactId;
    private NVersion version;
    private String scope;
    private String optional;
    private String type;
    private NEnvConditionBuilder condition = new DefaultNEnvConditionBuilder();
    private String classifier;
    private List<NId> exclusions = new ArrayList<NId>();
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    public DefaultNDependencyBuilder(NDependency d) {
        this.copyFrom(d);
    }

    public DefaultNDependencyBuilder() {
    }

    public DefaultNDependencyBuilder(String groupId, String artifactId) {
        this.groupId = NStringUtils.trimToNull(groupId);
        this.artifactId = NStringUtils.trimToNull(artifactId);
    }

    @Override
    public NDependencyBuilder setId(NId id) {
        if (id == null) {
            this.setRepository(null);
            this.setGroupId(null);
            this.setArtifactId(null);
            this.setVersion((String)null);
        } else {
            this.setRepository(id.getRepository());
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.setProperties(id.getProperties());
        }
        return this;
    }

    @Override
    public NDependencyBuilder setDependency(NDependencyBuilder value) {
        return this.copyFrom(value);
    }

    @Override
    public NDependencyBuilder copyFrom(NDependencyBuilder value) {
        if (value != null) {
            this.setRepository(value.getRepository());
            this.setGroupId(value.getGroupId());
            this.setArtifactId(value.getArtifactId());
            this.setVersion(value.getVersion());
            this.setScope(value.getScope());
            this.setOptional(value.getOptional());
            this.setExclusions(value.getExclusions());
            this.setClassifier(value.getClassifier());
            this.getCondition().copyFrom(value.getCondition());
            this.setType(value.getType());
            this.setProperties(value.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    public NDependencyBuilder copyFrom(NBootDependency value) {
        if (value != null) {
            this.setRepository(value.getRepository());
            this.setGroupId(value.getGroupId());
            this.setArtifactId(value.getArtifactId());
            this.setVersion(value.getVersion());
            this.setScope(value.getScope());
            this.setOptional(value.getOptional());
            this.setExclusions(value.getExclusions() == null ? null : value.getExclusions().stream().map(x -> x == null ? null : NId.get(x.toString()).get()).collect(Collectors.toList()));
            this.setClassifier(value.getClassifier());
            this.getCondition().copyFrom(value.getCondition() == null ? null : new DefaultNEnvConditionBuilder().copyFrom(value.getCondition()));
            this.setType(value.getType());
            this.setProperties(value.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    @Override
    public NDependencyBuilder copyFrom(NDependency value) {
        if (value != null) {
            this.setRepository(value.getRepository());
            this.setGroupId(value.getGroupId());
            this.setArtifactId(value.getArtifactId());
            this.setVersion(value.getVersion());
            this.setScope(value.getScope());
            this.setOptional(value.getOptional());
            this.setExclusions(value.getExclusions());
            this.setClassifier(value.getClassifier());
            this.getCondition().copyFrom(value.getCondition());
            this.setType(value.getType());
            this.setProperties(value.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    @Override
    public NDependencyBuilder setDependency(NDependency value) {
        return this.copyFrom(value);
    }

    @Override
    public NDependencyBuilder clear() {
        this.setRepository(null);
        this.setGroupId(null);
        this.setArtifactId(null);
        this.setVersion((NVersion)null);
        this.setScope((String)null);
        this.setOptional(null);
        this.setExclusions((List<NId>)null);
        this.setClassifier(null);
        this.getCondition().clear();
        this.setType(null);
        this.setProperties(null);
        return this;
    }

    @Override
    public boolean isOptional() {
        return this.optional != null && Boolean.parseBoolean(this.optional);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public NDependencyBuilder setType(String type) {
        this.type = NStringUtils.trimToNull(type);
        return this;
    }

    @Override
    public String getOptional() {
        return this.optional;
    }

    @Override
    public NDependencyBuilder setOptional(String optional) {
        String o = NStringUtils.trimToNull(optional);
        if ("false".equals(o)) {
            o = null;
        } else if ("true".equalsIgnoreCase(o)) {
            o = "true";
        }
        this.optional = o;
        return this;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public NDependencyBuilder setScope(NDependencyScope scope) {
        this.scope = scope == null ? "" : scope.toString();
        return this;
    }

    @Override
    public NDependencyBuilder setScope(String scope) {
        this.scope = NDependencyScope.parse(scope).orElse(NDependencyScope.API).id();
        return this;
    }

    @Override
    public NId toId() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (!NReservedUtils.isDependencyDefaultScope(this.scope)) {
            m.put("scope", this.scope);
        }
        if (!NBlankable.isBlank(this.optional) && !"false".equals(this.optional)) {
            m.put("optional", this.optional);
        }
        if (!NBlankable.isBlank(this.type)) {
            m.put("type", this.type);
        }
        if (this.exclusions.size() > 0) {
            m.put("exclusions", NReservedUtils.toDependencyExclusionListString(this.exclusions));
        }
        return NIdBuilder.of().setRepository(this.getRepository()).setGroupId(this.getGroupId()).setClassifier(this.getClassifier()).setArtifactId(this.getArtifactId()).setVersion(this.getVersion()).setCondition(this.getCondition()).setProperties(m).build();
    }

    @Override
    public String getRepository() {
        return this.repo;
    }

    @Override
    public NDependencyBuilder setRepository(String repository) {
        this.repo = NStringUtils.trimToNull(repository);
        return this;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public NDependencyBuilder setGroupId(String groupId) {
        this.groupId = NStringUtils.trimToNull(groupId);
        return this;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public NDependencyBuilder setArtifactId(String artifactId) {
        this.artifactId = NStringUtils.trimToNull(artifactId);
        return this;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public NDependencyBuilder setClassifier(String classifier) {
        this.classifier = NStringUtils.trimToNull(classifier);
        return this;
    }

    @Override
    public String getFullName() {
        if (NBlankable.isBlank(this.groupId)) {
            return NStringUtils.trim(this.artifactId);
        }
        return NStringUtils.trim(this.groupId) + ":" + NStringUtils.trim(this.artifactId);
    }

    @Override
    public NVersion getVersion() {
        return this.version;
    }

    @Override
    public NDependencyBuilder setVersion(NVersion version) {
        this.version = version == null ? NVersion.BLANK : version;
        return this;
    }

    @Override
    public NDependencyBuilder setVersion(String version) {
        this.version = NVersion.get(version).get();
        return this;
    }

    @Override
    public List<NId> getExclusions() {
        return this.exclusions;
    }

    @Override
    public NDependencyBuilder setExclusions(List<NId> exclusions) {
        this.exclusions = NReservedLangUtils.nonNullList(exclusions);
        return this;
    }

    @Override
    public NDependency build() {
        return new DefaultNDependency(this.getRepository(), this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getVersion(), this.getScope(), this.getOptional(), this.getExclusions(), this.getCondition().build(), this.getType(), this.getPropertiesQuery());
    }

    @Override
    public NDependencyBuilder setProperty(String property, String value) {
        if (property != null) {
            switch (property) {
                case "scope": {
                    this.setScope(value);
                    break;
                }
                case "version": {
                    this.setVersion(value);
                    break;
                }
                case "optional": {
                    this.setOptional(value);
                    break;
                }
                case "repo": {
                    this.setRepository(value);
                    break;
                }
                case "exclusions": {
                    this.setExclusions(value);
                    break;
                }
                case "os": {
                    this.condition.setOs(NStringUtils.parsePropertyIdList(value).get());
                    break;
                }
                case "arch": {
                    this.condition.setArch(NStringUtils.parsePropertyIdList(value).get());
                    break;
                }
                case "platform": {
                    this.condition.setPlatform(NStringUtils.parsePropertyIdList(value).get());
                    break;
                }
                case "osdist": {
                    this.condition.setOsDist(NStringUtils.parsePropertyIdList(value).get());
                    break;
                }
                case "desktop": {
                    this.condition.setDesktopEnvironment(NStringUtils.parsePropertyIdList(value).get());
                    break;
                }
                case "type": {
                    this.setType(value);
                    break;
                }
                default: {
                    if (value == null) {
                        this.properties.remove(property);
                        break;
                    }
                    this.properties.put(property, value);
                }
            }
        }
        return this;
    }

    @Override
    public NDependencyBuilder addPropertiesQuery(String propertiesQuery) {
        return this.addProperties(NStringMapFormat.DEFAULT.parse(propertiesQuery).get());
    }

    @Override
    public NDependencyBuilder addProperties(Map<String, String> queryMap) {
        if (queryMap != null) {
            for (Map.Entry<String, String> e : queryMap.entrySet()) {
                this.setProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    @Override
    public NDependencyBuilder setProperties(Map<String, String> queryMap) {
        this.properties.clear();
        if (queryMap != null) {
            for (Map.Entry<String, String> e : queryMap.entrySet()) {
                this.setProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    @Override
    public NDependencyBuilder setPropertiesQuery(String propertiesQuery) {
        this.setProperties(NStringMapFormat.DEFAULT.parse(propertiesQuery).get());
        return this;
    }

    @Override
    public String getPropertiesQuery() {
        return NStringMapFormat.DEFAULT.format(this.properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public NEnvConditionBuilder getCondition() {
        return this.condition;
    }

    @Override
    public NDependencyBuilder setCondition(NEnvCondition condition) {
        this.condition.clear();
        this.condition.copyFrom(condition);
        return this;
    }

    @Override
    public NDependencyBuilder setCondition(NEnvConditionBuilder condition) {
        this.condition.clear();
        this.condition.copyFrom(condition);
        return this;
    }

    @Override
    public NDependencyBuilder removeCondition() {
        this.condition.clear();
        return this;
    }

    public NDependencyBuilder setExclusions(String exclusions) {
        if (exclusions == null) {
            exclusions = "";
        }
        ArrayList<NId> ids = new ArrayList<NId>();
        for (String s : NReservedLangUtils.splitDefault(exclusions)) {
            NId ii = NId.get(s).orNull();
            if (ii == null) continue;
            ids.add(ii);
        }
        this.setExclusions(ids);
        return this;
    }

    public String toString() {
        return this.build().toString();
    }

    @Override
    public NDependencyBuilder copy() {
        return new DefaultNDependencyBuilder().copyFrom(this);
    }

    @Override
    public boolean isBlank() {
        return this.build().isBlank();
    }

    @Override
    public String getShortName() {
        return NReservedUtils.getIdShortName(this.groupId, this.artifactId, this.classifier);
    }

    @Override
    public String getLongName() {
        return NReservedUtils.getIdLongName(this.groupId, this.artifactId, this.version, this.classifier);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

