/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NArtifactCallBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.DefaultNArtifactCall;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.PROTOTYPE)
public class DefaultNArtifactCallBuilder
implements NArtifactCallBuilder,
Serializable {
    private static final long serialVersionUID = 1L;
    private NId id;
    private List<String> arguments = new ArrayList<String>();
    private String scriptName;
    private String scriptContent;

    public DefaultNArtifactCallBuilder() {
    }

    public DefaultNArtifactCallBuilder(NArtifactCall value) {
        this.setId(value.getId());
        this.setArguments(value.getArguments());
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    public NArtifactCallBuilder setScriptName(String scriptName) {
        this.scriptName = scriptName;
        return this;
    }

    @Override
    public String getScriptContent() {
        return this.scriptContent;
    }

    @Override
    public NArtifactCallBuilder setScriptContent(String scriptContent) {
        this.scriptContent = scriptContent;
        return this;
    }

    @Override
    public NId getId() {
        return this.id;
    }

    @Override
    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public DefaultNArtifactCallBuilder setArguments(String ... arguments) {
        this.arguments = new ArrayList<String>();
        if (arguments != null) {
            for (String argument : arguments) {
                if (argument == null) continue;
                this.arguments.add(argument);
            }
        }
        return this;
    }

    @Override
    public NArtifactCallBuilder setArguments(List<String> arguments) {
        this.arguments = new ArrayList<String>();
        if (arguments != null) {
            for (String argument : arguments) {
                if (argument == null) continue;
                this.arguments.add(argument);
            }
        }
        return this;
    }

    @Override
    public DefaultNArtifactCallBuilder setId(NId id) {
        this.id = id;
        return this;
    }

    @Override
    public NArtifactCallBuilder copyFrom(NArtifactCallBuilder value) {
        if (value != null) {
            this.setId(value.getId());
            this.setArguments(value.getArguments());
            this.setScriptName(value.getScriptName());
            this.setScriptContent(value.getScriptContent());
        }
        return this;
    }

    @Override
    public NArtifactCallBuilder copyFrom(NArtifactCall value) {
        if (value != null) {
            this.setId(value.getId());
            this.setArguments(value.getArguments());
            this.setScriptName(value.getScriptName());
            this.setScriptContent(value.getScriptContent());
        }
        return this;
    }

    @Override
    public NArtifactCallBuilder clear() {
        this.setId(null);
        this.arguments = new ArrayList<String>();
        this.scriptName = null;
        this.scriptContent = null;
        return this;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNArtifactCallBuilder that = (DefaultNArtifactCallBuilder)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.scriptName, that.scriptName) && Objects.equals(this.scriptContent, that.scriptContent);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.arguments, this.scriptName, this.scriptContent);
    }

    @Override
    public NArtifactCall build() {
        return new DefaultNArtifactCall(this.id, this.arguments, this.scriptName, this.scriptContent);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

