/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.artifact.NArtifactCall;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNArtifactCall
implements NArtifactCall,
Serializable {
    private static final long serialVersionUID = 1L;
    private NId id;
    private List<String> arguments;
    private String scriptName;
    private String scriptContent;

    protected DefaultNArtifactCall() {
    }

    public DefaultNArtifactCall(NArtifactCall other) {
        this.id = other.getId();
        this.arguments = NReservedLangUtils.nonNullList(other.getArguments());
        this.scriptName = NStringUtils.trimToNull(other.getScriptName());
        this.scriptContent = NStringUtils.trimToNull(other.getScriptContent());
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    public String getScriptContent() {
        return this.scriptContent;
    }

    @Override
    public boolean isBlank() {
        if (!NBlankable.isBlank(this.id)) {
            return false;
        }
        if (!NBlankable.isBlank(this.scriptName)) {
            return false;
        }
        if (!NBlankable.isBlank(this.scriptContent)) {
            return false;
        }
        if (this.arguments != null) {
            for (String d : this.arguments) {
                if (NBlankable.isBlank(d)) continue;
                return false;
            }
        }
        return true;
    }

    public DefaultNArtifactCall(NId id) {
        this(id, null, null, null);
    }

    public DefaultNArtifactCall(NId id, List<String> args, String scriptName, String scriptContent) {
        this.id = id;
        this.arguments = NReservedLangUtils.nonNullList(args);
        this.scriptName = NStringUtils.trimToNull(scriptName);
        this.scriptContent = scriptContent;
    }

    @Override
    public NId getId() {
        return this.id;
    }

    @Override
    public List<String> getArguments() {
        return NReservedLangUtils.unmodifiableList(this.arguments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNArtifactCall that = (DefaultNArtifactCall)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.arguments, that.arguments);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.arguments);
        return result;
    }

    public String toString() {
        return "NArtifactCall{id=" + this.id + ", arguments=" + this.arguments + '}';
    }
}

