/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.remote;

import net.thevpc.nuts.boot.NBootOptionsInfo;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.runtime.standalone.workspace.AbstractNWorkspace;
import net.thevpc.nuts.runtime.standalone.xtra.ntalk.NTalkClient;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NUnsupportedOperationException;

public abstract class RemoteNWorkspace
extends AbstractNWorkspace {
    public RemoteNWorkspace(NBootOptionsInfo info) {
        super(info);
    }

    public NElement createCall(String commandName, NElement body) {
        try (NTalkClient cli = new NTalkClient();){
            NObjectElement q = NElement.ofObjectBuilder().set("cmd", commandName).set("body", body).build();
            String json = NElementWriter.ofJson().toString(q);
            String wsURL = NWorkspace.of().getBootOptions().getWorkspace().orNull();
            byte[] result = cli.request("nuts/ws:" + wsURL, json.getBytes());
            NObjectElement resultObject = NElementParser.ofJson().parse(result, NObjectElement.class);
            NElements prv = NElements.of();
            boolean success = resultObject.getBooleanValue("success").get();
            if (success) {
                NElement nElement = resultObject.get("body").orNull();
                return nElement;
            }
            throw new NException(NMsg.ofC("unable to call %s", NText.ofStyled(commandName, NTextStyle.primary1())));
        }
    }

    public NElement createCall(String commandName, String callId, NElement body) {
        return NElement.ofObjectBuilder().set("cmd", (NElement)NElement.ofString(commandName)).set("id", (NElement)NElement.ofString(callId)).set("body", body).build();
    }

    public <T> T remoteCall(NElement call, Class<T> expectedType) {
        throw new NUnsupportedOperationException(NMsg.ofPlain("not yet supported remoteCall"));
    }
}

