/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.deprecated;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NBootOptionsBuilder;
import net.thevpc.nuts.core.NConfirmationMode;
import net.thevpc.nuts.core.NNoSessionCancelException;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.io.NAsk;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.runtime.deprecated.NReservedDeleteFilesContext;
import net.thevpc.nuts.runtime.deprecated.NReservedDeleteFilesContextImpl;
import net.thevpc.nuts.runtime.standalone.NWorkspaceProfilerImpl;
import net.thevpc.nuts.runtime.standalone.io.NCoreIOUtils;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NCancelException;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;

public class NDeleteFileHelper {
    public static final String DELETE_FOLDERS_HEADER = "ATTENTION ! You are about to delete nuts workspace files.";

    public static long deleteStoreLocations(NBootOptions lastBootOptions, NBootOptions o, boolean includeRoot, NLog bLog, Object[] locations, Supplier<String> readline) {
        if (lastBootOptions == null) {
            return 0L;
        }
        NConfirmationMode confirm = o.getConfirm().orElse(NConfirmationMode.ASK);
        if (confirm == NConfirmationMode.ASK && o.getOutputFormat().orElse(NContentType.PLAIN) != NContentType.PLAIN) {
            throw new NExecutionException(NMsg.ofPlain("unable to switch to interactive mode for non plain text output format. You need to provide default response (-y|-n) for resetting/recovering workspace. You was asked to confirm deleting folders as part as recover/reset option."), 255);
        }
        bLog.log(NMsg.ofC("delete workspace location(s) at : %s", lastBootOptions.getWorkspace().orNull()).asFinestAlert());
        boolean force = false;
        switch (confirm) {
            case ASK: {
                break;
            }
            case YES: {
                force = true;
                break;
            }
            case NO: 
            case ERROR: {
                bLog.log(NMsg.ofPlain("reset cancelled (applied '--no' argument)").asWarningAlert());
                throw new NNoSessionCancelException(NMsg.ofPlain("cancel delete folder"));
            }
        }
        ArrayList<Path> folders = new ArrayList<Path>();
        if (includeRoot) {
            folders.add(Paths.get(lastBootOptions.getWorkspace().get(), new String[0]));
        }
        for (Object ovalue : locations) {
            if (ovalue == null) continue;
            if (ovalue instanceof NStoreType) {
                NStoreType value = (NStoreType)ovalue;
                String p = NCoreIOUtils.getStoreLocationPath(lastBootOptions, value);
                if (p == null) continue;
                folders.add(Paths.get(p, new String[0]));
                continue;
            }
            if (ovalue instanceof Path) {
                folders.add((Path)ovalue);
                continue;
            }
            if (ovalue instanceof File) {
                folders.add(((File)ovalue).toPath());
                continue;
            }
            throw new NIllegalArgumentException(NMsg.ofC("unsupported path type : %s", ovalue));
        }
        NBootOptionsBuilder optionsCopy = o.builder();
        if (optionsCopy.getBot().orElse(false).booleanValue() || !NReservedLangUtils.isGraphicalDesktopEnvironment()) {
            optionsCopy.setGui(false);
        }
        return NDeleteFileHelper.deleteAndConfirmAll(folders.toArray(new Path[0]), force, DELETE_FOLDERS_HEADER, bLog, optionsCopy.build(), readline);
    }

    public static long deleteAndConfirmAll(Path[] folders, boolean force, String header, NLog bLog, NBootOptions bOptions, Supplier<String> readline) {
        return NDeleteFileHelper.deleteAndConfirmAll(folders, force, new NReservedDeleteFilesContextImpl(), header, bLog, bOptions, readline);
    }

    public static long deleteAndConfirmAll(Path[] folders, boolean force, NReservedDeleteFilesContext refForceAll, String header, NLog bLog, NBootOptions bOptions, Supplier<String> readline) {
        long count = 0L;
        boolean headerWritten = false;
        if (folders != null) {
            NSession session = NSession.get().orNull();
            for (Path child : folders) {
                if (!Files.exists(child, new LinkOption[0])) continue;
                if (!headerWritten) {
                    headerWritten = true;
                    if (!(force || refForceAll.isForce() || header == null || bOptions.getBot().orElse(false).booleanValue())) {
                        if (session != null) {
                            session.err().println(header);
                        } else {
                            bLog.log(NMsg.ofC("%s", header).asWarningAlert());
                        }
                    }
                }
                count += NDeleteFileHelper.deleteAndConfirm(child, force, refForceAll, bLog, bOptions, readline);
            }
        }
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long deleteAndConfirm(Path directory, boolean force, NReservedDeleteFilesContext refForceAll, NLog bLog, NBootOptions bOptions, Supplier<String> readline) {
        if (!Files.exists(directory, new LinkOption[0])) return 0L;
        if (!force && !refForceAll.isForce() && refForceAll.accept(directory)) {
            String line = null;
            NSession session = NSession.get().orNull();
            if (session != null) {
                line = NAsk.of().forString(NMsg.ofC("do you confirm deleting %s [y/n/c/a] (default 'n') ?", directory)).getValue();
            } else if (bOptions.getBot().orElse(false).booleanValue()) {
                if (bOptions.getConfirm().orElse(NConfirmationMode.ASK) != NConfirmationMode.YES) throw new NIllegalArgumentException(NMsg.ofPlain("failed to delete files in --bot mode without auto confirmation"));
                line = "y";
            } else if (bOptions.getGui().orElse(false).booleanValue()) {
                line = NReservedLangUtils.inputString(NMsg.ofC("do you confirm deleting %s [y/n/c/a] (default 'n') ?", directory).toString(), null, readline, bLog);
            } else {
                NConfirmationMode cc = bOptions.getConfirm().orElse(NConfirmationMode.ASK);
                switch (cc) {
                    case YES: {
                        line = "y";
                        break;
                    }
                    case NO: {
                        line = "n";
                        break;
                    }
                    case ERROR: {
                        throw new NIllegalArgumentException(NMsg.ofPlain("error response"));
                    }
                    case ASK: {
                        bLog.log(NMsg.ofC("do you confirm deleting %s [y/n/c/a] (default 'n') ? : ", directory).withLevel(Level.OFF).withIntent(NMsgIntent.ALERT));
                        line = readline.get();
                    }
                }
            }
            if ("a".equalsIgnoreCase(line) || "all".equalsIgnoreCase(line)) {
                refForceAll.setForce(true);
            } else {
                if ("c".equalsIgnoreCase(line)) {
                    throw new NCancelException();
                }
                if (!NLiteral.of(line).asBoolean().orElse(false).booleanValue()) {
                    refForceAll.ignore(directory);
                    return 0L;
                }
            }
        }
        final long[] count = new long[1];
        try {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    count[0] = count[0] + 1L;
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    count[0] = count[0] + 1L;
                    boolean deleted = false;
                    for (int i = 0; i < 2; ++i) {
                        try {
                            Files.delete(dir);
                            deleted = true;
                            break;
                        }
                        catch (DirectoryNotEmptyException directoryNotEmptyException) {
                            NWorkspaceProfilerImpl.sleep(500L, "NDeleteFileHelper::workaround-delete");
                            continue;
                        }
                    }
                    if (!deleted) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            count[0] = count[0] + 1L;
            bLog.log(NMsg.ofC("delete folder : %s (%s files/folders deleted)", directory, count[0]).asFinestAlert());
            return count[0];
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

