/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.reflect;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NOptional;

public class NReflectUtils {
    private NReflectUtils() {
    }

    public static boolean isValidIdentifier(String anyType, String extraWordChars) {
        if (anyType == null) {
            return false;
        }
        char[] chars = anyType.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i == 0) {
                if (c == '_' || c == '-' || c == '.') {
                    return false;
                }
                if (!(Character.isJavaIdentifierStart(c) || extraWordChars != null && extraWordChars.indexOf(c) >= 0)) {
                    return false;
                }
            }
            if (!(Character.isJavaIdentifierPart(c) || extraWordChars != null && extraWordChars.indexOf(c) >= 0)) {
                return false;
            }
            if (i != chars.length - 1 || c != '_' && c != '-' && c != '.') continue;
            return false;
        }
        return true;
    }

    public static Object getDefaultValue(Class<?> anyType) {
        NAssert.requireNonNull(anyType, "type");
        switch (anyType.getName()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
            case "void": {
                return null;
            }
        }
        return null;
    }

    public static NOptional<Class<?>> toBoxedType(Class<?> anyType) {
        if (anyType == null) {
            return NOptional.ofNamedError("no boxed type for null");
        }
        switch (anyType.getName()) {
            case "boolean": {
                return NOptional.of(Boolean.class);
            }
            case "byte": {
                return NOptional.of(Byte.class);
            }
            case "short": {
                return NOptional.of(Short.class);
            }
            case "int": {
                return NOptional.of(Integer.class);
            }
            case "long": {
                return NOptional.of(Long.class);
            }
            case "char": {
                return NOptional.of(Character.class);
            }
            case "float": {
                return NOptional.of(Float.class);
            }
            case "double": {
                return NOptional.of(Double.class);
            }
            case "void": {
                return NOptional.of(Void.class);
            }
        }
        return NOptional.ofNamedError(NMsg.ofC("not a primitive type %s", anyType));
    }

    public static NOptional<Class<?>> toPrimitiveType(Class<?> anyType) {
        if (anyType == null) {
            return NOptional.ofNamedError("no boxed type for null");
        }
        switch (anyType.getName()) {
            case "java.lang.Boolean": {
                return NOptional.of(Boolean.TYPE);
            }
            case "java.lang.Byte": {
                return NOptional.of(Byte.TYPE);
            }
            case "java.lang.Short": {
                return NOptional.of(Short.TYPE);
            }
            case "java.lang.Integer": {
                return NOptional.of(Integer.TYPE);
            }
            case "java.lang.Long": {
                return NOptional.of(Long.TYPE);
            }
            case "java.lang.Character": {
                return NOptional.of(Character.TYPE);
            }
            case "java.lang.Float": {
                return NOptional.of(Float.TYPE);
            }
            case "java.lang.Double": {
                return NOptional.of(Double.TYPE);
            }
            case "java.lang.Void": {
                return NOptional.of(Void.TYPE);
            }
        }
        return NOptional.ofNamedError(NMsg.ofC("not a primitive type %s", anyType));
    }

    public static Set<Class<?>> findAllSuperClassesAndInterfaces(Class<?> clazz) {
        LinkedHashSet classes = new LinkedHashSet();
        LinkedHashSet nextLevel = new LinkedHashSet();
        nextLevel.add(clazz);
        while (!nextLevel.isEmpty()) {
            classes.addAll(nextLevel);
            LinkedHashSet thisLevel = new LinkedHashSet(nextLevel);
            nextLevel.clear();
            for (Class each : thisLevel) {
                Class superClass = each.getSuperclass();
                if (superClass != null && superClass != Object.class) {
                    nextLevel.add(superClass);
                }
                for (Class<?> eachInt : each.getInterfaces()) {
                    nextLevel.add(eachInt);
                }
            }
        }
        return classes;
    }

    public static Class<?> commonAncestor(Class<?> ... classes) {
        return NReflectUtils.commonAncestors(classes).get(0);
    }

    public static List<Class<?>> commonAncestors(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            ArrayList a = new ArrayList(1);
            a.add(Object.class);
            return a;
        }
        LinkedHashSet rollingIntersect = null;
        for (int i = 0; i < classes.length; ++i) {
            if (classes[i] == null) continue;
            if (rollingIntersect == null) {
                rollingIntersect = new LinkedHashSet(NReflectUtils.findAllSuperClassesAndInterfaces(classes[0]));
                continue;
            }
            rollingIntersect.retainAll(NReflectUtils.findAllSuperClassesAndInterfaces(classes[i]));
        }
        if (rollingIntersect == null) {
            ArrayList a = new ArrayList(1);
            a.add(Object.class);
            return a;
        }
        return new ArrayList(rollingIntersect);
    }
}

