/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Objects;
import net.thevpc.nuts.reflect.NPlatformArgsSignature;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class NPlatformNamedSignature {
    private NPlatformArgsSignature args;
    private String name;

    public static NPlatformNamedSignature of(String name, Type ... types) {
        return new NPlatformNamedSignature(name, types, false);
    }

    public static NPlatformNamedSignature ofVarArgs(String name, Type ... types) {
        NPlatformNamedSignature.checkVararg(types);
        return new NPlatformNamedSignature(name, types, true);
    }

    private static void checkVararg(Type ... types) {
        if (types.length == 0) {
            throw new IllegalArgumentException("invalid vararg with zero length arguments");
        }
        Type lastType = types[types.length - 1];
        if (!(lastType instanceof Class)) {
            throw new IllegalArgumentException("last argument must be a valid array for vararg methods");
        }
        if (!(lastType instanceof GenericArrayType || lastType instanceof Class && ((Class)lastType).isArray())) {
            throw new IllegalArgumentException("last argument must be a valid array for vararg methods");
        }
    }

    private NPlatformNamedSignature(String name, Type[] types, boolean vararg) {
        this.name = name;
        this.args = vararg ? NPlatformArgsSignature.ofVarArgs(types) : NPlatformArgsSignature.of(types);
    }

    public Type getType(int index) {
        return this.args.getType(index);
    }

    public NPlatformNamedSignature setVararg(boolean vararg) {
        if (vararg == this.isVararg()) {
            return this;
        }
        return this.args.isVararg() ? NPlatformNamedSignature.ofVarArgs(this.name, this.args.types()) : NPlatformNamedSignature.of(this.name, this.args.types());
    }

    public NPlatformNamedSignature set(Type any, int pos) {
        return this.args.isVararg() ? NPlatformNamedSignature.ofVarArgs(this.name, this.args.set(any, pos).types()) : NPlatformNamedSignature.of(this.name, this.args.set(any, pos).types());
    }

    public int size() {
        return this.args.size();
    }

    public Type[] types() {
        return this.args.types();
    }

    public boolean isVararg() {
        return this.args.isVararg();
    }

    public String toString() {
        if (NBlankable.isBlank(this.name)) {
            return this.args.toString();
        }
        return this.name.trim() + this.args.toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPlatformNamedSignature nSig = (NPlatformNamedSignature)o;
        return Objects.equals(this.name, nSig.name) && Objects.deepEquals(this.args, nSig.args);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.args);
    }

    public String name() {
        return this.name;
    }

    public NPlatformArgsSignature args() {
        return this.args;
    }

    private boolean nameMatches(String name, String namePattern) {
        if (NBlankable.isBlank(namePattern) || NBlankable.isBlank(name)) {
            return true;
        }
        if (NStringUtils.trim(namePattern).equals("*")) {
            return true;
        }
        return name.matches(namePattern);
    }

    public boolean matches(NPlatformNamedSignature other) {
        return this.nameMatches(this.name, other.name) && this.args.matches(other.args);
    }
}

