/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.reflect;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Objects;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.reflect.NBeanContainer;
import net.thevpc.nuts.util.NAssert;

public class NBeanRef {
    private String id;
    private NElement variant;

    public static NBeanRef of(String id, NElement variant) {
        return new NBeanRef(id, variant);
    }

    public static NBeanRef of(String id) {
        return new NBeanRef(id, NElement.ofNull());
    }

    public NBeanRef(String id, NElement variant) {
        this.id = id;
        this.variant = variant;
    }

    public String getId() {
        return this.id;
    }

    public NElement getVariant() {
        return this.variant;
    }

    public <T> T as(Class<T> type) {
        NAssert.requireNonNull(type, "type");
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type, NBeanRefHolder.class}, (InvocationHandler)new BeanInvocationHandler(this));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBeanRef nBeanRef = (NBeanRef)o;
        return Objects.equals(this.id, nBeanRef.id) && Objects.equals(this.variant, nBeanRef.variant);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.variant);
    }

    public String toString() {
        return "NBeanRef{id=" + this.id + ", variant=" + this.variant + "}";
    }

    static interface NBeanRefHolder {
        public NBeanRef asBeanRef();
    }

    private static class BeanInvocationHandler
    implements InvocationHandler,
    Serializable {
        private final NBeanRef ref;

        public BeanInvocationHandler(NBeanRef ref) {
            this.ref = ref;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("asBeanRef") && method.getParameterCount() == 0) {
                return this.ref;
            }
            Object bean = NBeanContainer.current().of(this.ref);
            return method.invoke(bean, args);
        }

        public String toString() {
            return "NBeanRef{id=" + this.ref.getId() + ", variant=" + this.ref.getVariant() + "}";
        }
    }
}

