/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.platform;

import java.util.Objects;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NConfigItem;
import net.thevpc.nuts.platform.NPlatformFamily;
import net.thevpc.nuts.util.NBlankable;

public class NPlatformLocation
extends NConfigItem
implements Cloneable {
    public static final long serialVersionUID = 3L;
    private final NId id;
    private final NPlatformFamily platformType;
    private final String name;
    private final String packaging;
    private final String product;
    private final String path;
    private final String version;
    private final int priority;

    public NPlatformLocation(NId id, String product, String name, String path, String version, String packaging, int priority) {
        this.id = id;
        this.platformType = id == null || NBlankable.isBlank(id.getArtifactId()) ? NPlatformFamily.JAVA : NPlatformFamily.parse(id.getArtifactId()).orElse(NPlatformFamily.UNKNOWN);
        this.product = product;
        this.name = name;
        this.path = path;
        this.version = version;
        this.packaging = packaging;
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }

    public NPlatformLocation setPriority(int priority) {
        return new NPlatformLocation(this.id, this.product, this.name, this.path, this.version, this.packaging, priority);
    }

    public NId getId() {
        return this.id;
    }

    public NPlatformFamily getPlatformType() {
        return this.platformType;
    }

    public String getProduct() {
        return this.product;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.packaging, this.product, this.path, this.version, this.priority);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NPlatformLocation that = (NPlatformLocation)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.packaging, that.packaging) && Objects.equals(this.product, that.product) && Objects.equals(this.path, that.path) && Objects.equals(this.version, that.version) && Objects.equals(this.priority, that.priority);
    }

    public String toString() {
        return "NutsPlatformLocation{id=" + this.id + ", name='" + this.name + '\'' + ", packaging='" + this.packaging + '\'' + ", product='" + this.product + '\'' + ", path='" + this.path + '\'' + ", version='" + this.version + '\'' + ", priority=" + this.priority + '}';
    }

    public NPlatformLocation copy() {
        try {
            NPlatformLocation cloned = (NPlatformLocation)this.clone();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

