/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.platform;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NPlatformFamily implements NEnum
{
    OS,
    JAVA,
    DOTNET,
    PYTHON,
    JAVASCRIPT,
    UNKNOWN;

    private final String id = NNameFormat.ID_NAME.format(this.name());

    public static NOptional<NPlatformFamily> parse(String value) {
        return NEnumUtils.parseEnum(value, NPlatformFamily.class, s -> {
            switch (s.getNormalizedValue()) {
                case "OS": {
                    return NOptional.of(OS);
                }
                case "JAVA": 
                case "JAVAW": 
                case "JRE": 
                case "JDK": 
                case "OPENJDK": {
                    return NOptional.of(JAVA);
                }
                case "NET": 
                case "DOTNET": {
                    return NOptional.of(DOTNET);
                }
                case "PYTHON": {
                    return NOptional.of(PYTHON);
                }
                case "JS": 
                case "JAVASCRIPT": {
                    return NOptional.of(JAVASCRIPT);
                }
                case "UNKNOWN": {
                    return NOptional.of(UNKNOWN);
                }
            }
            return null;
        });
    }

    @Override
    public String id() {
        return this.id;
    }
}

