/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.platform;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NOsFamily implements NEnum
{
    WINDOWS,
    LINUX,
    MACOS,
    UNIX,
    UNKNOWN;

    private static final NOsFamily _curr;
    private final String id = NNameFormat.ID_NAME.format(this.name());

    public static NOptional<NOsFamily> parse(String value) {
        return NEnumUtils.parseEnum(value, NOsFamily.class, s -> {
            String e;
            switch (e = s.getNormalizedValue()) {
                case "W": 
                case "WIN": 
                case "WINDOWS": {
                    return NOptional.of(WINDOWS);
                }
                case "L": 
                case "LINUX": {
                    return NOptional.of(LINUX);
                }
                case "M": 
                case "MAC": 
                case "MACOS": {
                    return NOptional.of(MACOS);
                }
                case "U": 
                case "UNIX": {
                    return NOptional.of(UNIX);
                }
                case "unknown": {
                    return NOptional.of(UNKNOWN);
                }
            }
            if (e.startsWith("LINUX")) {
                return NOptional.of(LINUX);
            }
            if (e.startsWith("WIN")) {
                return NOptional.of(WINDOWS);
            }
            if (e.startsWith("MAC")) {
                return NOptional.of(MACOS);
            }
            if (e.startsWith("SUNOS") || e.startsWith("SUN_OS")) {
                return NOptional.of(UNIX);
            }
            if (e.startsWith("FREEBSD") || e.startsWith("FREE_BSD")) {
                return NOptional.of(UNIX);
            }
            switch (e) {
                case "DOS": 
                case "MSDOS": 
                case "MS_DOS": {
                    return NOptional.of(WINDOWS);
                }
                case "NETWARE": 
                case "NET_WARE": {
                    return NOptional.of(UNKNOWN);
                }
                case "OS2": 
                case "OS_2": {
                    return NOptional.of(UNKNOWN);
                }
                case "TANDEM": {
                    return NOptional.of(UNKNOWN);
                }
                case "Z_OS": 
                case "ZOS": {
                    return NOptional.of(UNKNOWN);
                }
                case "OS400": 
                case "OS_400": {
                    return NOptional.of(UNIX);
                }
                case "OPENVMS": 
                case "OPEN_VMS": {
                    return NOptional.of(UNKNOWN);
                }
            }
            return null;
        });
    }

    public boolean isPosix() {
        switch (this.ordinal()) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean isUnix() {
        switch (this.ordinal()) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public boolean isMacOs() {
        switch (this.ordinal()) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean isWindow() {
        switch (this.ordinal()) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    public boolean isUnknown() {
        switch (this.ordinal()) {
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static NOsFamily getCurrent() {
        return _curr;
    }

    @Override
    public String id() {
        return this.id;
    }

    static {
        _curr = NOsFamily.parse(System.getProperty("os.name")).orElse(UNKNOWN);
    }
}

