/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.platform;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NArchFamily implements NEnum
{
    X86_32,
    X86_64,
    ITANIUM_32,
    SPARC_32,
    SPARC_64,
    ARM_32,
    ARM_64,
    AARCH_64,
    MIPS_32,
    MIPSEL_32,
    MIPS_64,
    MIPSEL_64,
    PPC_32,
    PPCLE_32,
    PPC_64,
    PPCLE_64,
    S390_32,
    S390_64,
    ITANIUM_64,
    UNKNOWN;

    private static final NArchFamily _curr;
    private final String id = NNameFormat.ID_NAME.format(this.name());

    public static NOptional<NArchFamily> parse(String value) {
        return NEnumUtils.parseEnum(value, NArchFamily.class, s -> {
            String arch;
            switch (arch = s.getNormalizedValue()) {
                case "X8632": 
                case "X86": 
                case "I386": 
                case "I486": 
                case "I586": 
                case "I686": 
                case "IA32": 
                case "X32": 
                case "X86_32": {
                    return NOptional.of(X86_32);
                }
                case "X8664": 
                case "AMD64": 
                case "IA32E": 
                case "EM64T": 
                case "X64": 
                case "X86_64": {
                    return NOptional.of(X86_64);
                }
                case "IA64N": 
                case "ITANIUM_32": {
                    return NOptional.of(ITANIUM_32);
                }
                case "SPARC": 
                case "SPARC32": 
                case "SPARC_32": {
                    return NOptional.of(SPARC_32);
                }
                case "SPARCV9": 
                case "SPARC64": 
                case "SPARC_64": {
                    return NOptional.of(SPARC_64);
                }
                case "ARM": 
                case "ARM32": 
                case "ARM_32": {
                    return NOptional.of(ARM_32);
                }
                case "ARM64": 
                case "AARCH64": 
                case "AARCH_64": {
                    return NOptional.of(AARCH_64);
                }
                case "MIPS": 
                case "MIPS32": 
                case "MIPS_32": {
                    return NOptional.of(MIPS_32);
                }
                case "MIPS_64": {
                    return NOptional.of(MIPS_64);
                }
                case "MIPSEL": 
                case "MIPS32EL": 
                case "MIPSEL_32": {
                    return NOptional.of(MIPSEL_32);
                }
                case "MIPS64": 
                case "MIPS64EL": 
                case "MIPSEL_64": {
                    return NOptional.of(MIPSEL_64);
                }
                case "PPC": 
                case "PPC32": 
                case "PPC_32": {
                    return NOptional.of(PPC_32);
                }
                case "PPC64": 
                case "PPC_64": {
                    return NOptional.of(PPC_64);
                }
                case "PPCLE": 
                case "PPCLE32": 
                case "PPCLE_32": {
                    return NOptional.of(PPCLE_32);
                }
                case "PPC64LE": 
                case "PPCLE_64": {
                    return NOptional.of(PPCLE_64);
                }
                case "S390": 
                case "S390_32": {
                    return NOptional.of(S390_32);
                }
                case "S390X": 
                case "S390_64": {
                    return NOptional.of(S390_64);
                }
                case "ARM_64": {
                    return NOptional.of(ARM_64);
                }
                case "IA64W": 
                case "ITANIUM64": 
                case "ITANIUM_64": {
                    return NOptional.of(ITANIUM_64);
                }
                case "UNKNOWN": {
                    return NOptional.of(UNKNOWN);
                }
            }
            if (arch.startsWith("IA64W") && arch.length() == 6) {
                return NOptional.of(ITANIUM_64);
            }
            return null;
        });
    }

    public boolean is64Bit() {
        return this.getBits() == 64;
    }

    public boolean isArm() {
        switch (this.ordinal()) {
            case 5: 
            case 6: {
                return true;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return false;
            }
        }
        return false;
    }

    public boolean isX86() {
        switch (this.ordinal()) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return false;
            }
        }
        return false;
    }

    public int getBits() {
        switch (this.ordinal()) {
            case 1: 
            case 4: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                return 64;
            }
            case 0: 
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 16: {
                return 32;
            }
            case 19: {
                return -1;
            }
        }
        return -1;
    }

    public static NArchFamily getCurrent() {
        return _curr;
    }

    @Override
    public String id() {
        return this.id;
    }

    static {
        _curr = NArchFamily.parse(System.getProperty("os.arch")).orElse(UNKNOWN);
    }
}

