/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.net;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.net.DefaultNConnectionString;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.net.NConnectionStringBuilder;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringBuilder;
import net.thevpc.nuts.util.NStringMapFormat;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNConnectionStringBuilder
implements Cloneable,
NConnectionStringBuilder {
    private static Pattern CONNECTION_PATTERN = Pattern.compile("((?<user>([a-zA-Z]([a-zA-Z0-9_-])*))(:(?<password>([^@]+)))?@)?((?<server>([a-zA-Z0-9._-]+))(:(?<port>[0-9]+))?)(?<path>([/:].*))?");
    private static Pattern PROTOCOLE_PATTERN = Pattern.compile("(?<protocol>[a-zA-Z]([a-zA-Z0-9_+-])*):(?<path>(/.*))");
    private static Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z]([a-zA-Z0-9_-])*");
    private String protocol;
    private String userName;
    private String password;
    private String host;
    private String port;
    private String path;
    private boolean normalized;
    private Map<String, List<String>> queryMap;

    public DefaultNConnectionStringBuilder() {
    }

    public DefaultNConnectionStringBuilder(NConnectionString other) {
        if (other != null) {
            this.protocol = other.getProtocol();
            this.userName = other.getUserName();
            this.password = other.getPassword();
            this.host = other.getHost();
            this.port = other.getPort();
            this.path = other.getPath();
            this.queryMap = DefaultNConnectionStringBuilder.prepareQueryMap(other.getQueryMap().orNull(), false);
        }
    }

    @Override
    public NConnectionString build() {
        if (this.normalized) {
            Map<String, List<String>> queryMap2 = DefaultNConnectionStringBuilder.prepareQueryMap(this.queryMap, true);
            String protocol2 = NStringUtils.trimToNull(this.protocol);
            String userName2 = NStringUtils.trimToNull(this.userName);
            String host2 = NStringUtils.trimToNull(this.host);
            String port2 = NStringUtils.trimToNull(this.port);
            String path2 = NStringUtils.trimToNull(this.path);
            return new DefaultNConnectionString(protocol2, userName2, this.password, host2, port2, path2, queryMap2);
        }
        return new DefaultNConnectionString(this.protocol, this.userName, this.password, this.host, this.port, this.path, this.queryMap);
    }

    public static NOptional<NConnectionStringBuilder> of(String value) {
        String path;
        String protocol;
        if (value == null || NBlankable.isBlank(value)) {
            return NOptional.ofNamedEmpty("Connection String");
        }
        value = value.trim();
        DefaultNConnectionStringBuilder v = new DefaultNConnectionStringBuilder();
        Matcher e = PROTOCOLE_PATTERN.matcher(value);
        if (e.matches()) {
            protocol = DefaultNConnectionStringBuilder.safeUrlDecode(e.group("protocol"));
            path = e.group("path");
            if (path.startsWith("//") && !"file".equals(protocol)) {
                path = path.substring(2);
            }
        } else {
            protocol = null;
            path = value;
        }
        value = path;
        v.setProtocol(protocol);
        Matcher matcher = NAME_PATTERN.matcher(value);
        String pathAndQuery = null;
        if (matcher.matches()) {
            if (protocol == null) {
                pathAndQuery = "/" + value;
            } else {
                v.setHost(value);
            }
        } else {
            matcher = CONNECTION_PATTERN.matcher(value);
            if (matcher.matches()) {
                v.setUserName(matcher.group("user"));
                v.setPassword(matcher.group("password"));
                v.setHost(matcher.group("server"));
                v.setPort(matcher.group("port"));
                String spath = matcher.group("path");
                if (spath != null && spath.startsWith(":")) {
                    spath = spath.substring(1);
                }
                pathAndQuery = spath;
            } else {
                pathAndQuery = value;
            }
        }
        if (pathAndQuery != null) {
            int i = pathAndQuery.indexOf(63);
            if (i >= 0) {
                String p = pathAndQuery.substring(0, i);
                String q = pathAndQuery.substring(i + 1);
                v.setPath(p);
                v.setQueryString(q);
            } else {
                v.setPath(pathAndQuery);
            }
        }
        return NOptional.of(v);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public NConnectionStringBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public NConnectionStringBuilder setPassword(String password) {
        this.password = password;
        return this;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public NConnectionStringBuilder setHost(String host) {
        this.host = host;
        return this;
    }

    @Override
    public DefaultNConnectionStringBuilder getRoot() {
        return this.copy().setPath("/");
    }

    @Override
    public DefaultNConnectionStringBuilder getParent() {
        String ppath = this.path;
        if (NBlankable.isBlank(ppath) || "/".equals(ppath)) {
            return null;
        }
        while (ppath.endsWith("/")) {
            ppath = ppath.substring(0, ppath.length() - 1);
        }
        if (ppath.isEmpty()) {
            return this.copy().setPath("/");
        }
        int i = ppath.lastIndexOf(47);
        ppath = i <= 0 ? "/" : ppath.substring(0, i + 1);
        return this.copy().setPath(ppath);
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public DefaultNConnectionStringBuilder setPort(String port) {
        this.port = port;
        return this;
    }

    public String toString() {
        return this.build().toString();
    }

    @Override
    public NConnectionStringBuilder setQueryMap(Map<String, List<String>> queryMap) {
        this.queryMap = DefaultNConnectionStringBuilder.prepareQueryMap(queryMap, false);
        return this;
    }

    static Map<String, List<String>> prepareQueryMap(Map<String, List<String>> queryMap, boolean normalize) {
        if (queryMap == null) {
            return null;
        }
        if (normalize) {
            TreeMap<String, List<String>> queryMap2 = null;
            for (Map.Entry<String, List<String>> q : queryMap.entrySet()) {
                List<String> list = q.getValue();
                if (list == null || (list = list.stream().filter(x -> x != null).collect(Collectors.toList())).isEmpty()) continue;
                if (queryMap2 == null) {
                    queryMap2 = new TreeMap<String, List<String>>();
                }
                queryMap2.put(q.getKey(), list);
            }
            return queryMap2;
        }
        LinkedHashMap<String, List<String>> queryMap2 = null;
        for (Map.Entry<String, List<String>> q : queryMap.entrySet()) {
            List<String> list = q.getValue();
            if (list == null || (list = list.stream().filter(x -> x != null).collect(Collectors.toList())).isEmpty()) continue;
            if (queryMap2 == null) {
                queryMap2 = new LinkedHashMap<String, List<String>>();
            }
            queryMap2.put(q.getKey(), list);
        }
        return queryMap2;
    }

    static Map<String, List<String>> deserializeQueryMap(String queryString) {
        if (NBlankable.isBlank(queryString)) {
            return null;
        }
        NOptional<Map<String, List<String>>> qq = NStringMapFormat.URL_FORMAT.parseDuplicates(queryString);
        return qq.map(x -> {
            LinkedHashMap r = new LinkedHashMap();
            for (Map.Entry ee : x.entrySet()) {
                r.put(DefaultNConnectionStringBuilder.safeUrlDecode((String)ee.getKey()), Collections.unmodifiableList(((List)ee.getValue()).stream().map(DefaultNConnectionStringBuilder::safeUrlDecode).collect(Collectors.toList())));
            }
            return Collections.unmodifiableMap(r);
        }).orElse(null);
    }

    static String serializeQueryMap(Map<String, List<String>> queryMap) {
        if (queryMap != null) {
            NStringBuilder sb = new NStringBuilder();
            for (Map.Entry<String, List<String>> e : queryMap.entrySet()) {
                String k = e.getKey();
                if (k == null || k.isEmpty()) continue;
                List<String> v = e.getValue();
                v = v != null ? v.stream().filter(y -> y != null).collect(Collectors.toList()) : new ArrayList<String>();
                if (v.isEmpty()) {
                    v.add("");
                }
                for (String s : v) {
                    if (!sb.isEmpty()) {
                        sb.append("&");
                    }
                    sb.append(DefaultNConnectionStringBuilder.safeUrlEncode(k));
                    sb.append("=");
                    sb.append(DefaultNConnectionStringBuilder.safeUrlEncode(s));
                }
            }
            if (!sb.isEmpty()) {
                return sb.toString();
            }
            return "";
        }
        return null;
    }

    @Override
    public NOptional<Map<String, List<String>>> getQueryMap() {
        return NOptional.ofNamed(this.queryMap, "queryMap");
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNConnectionStringBuilder that = (DefaultNConnectionStringBuilder)o;
        return Objects.equals(this.protocol, that.protocol) && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.path, that.path) && Objects.equals(this.queryMap, that.queryMap);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.userName, this.password, this.host, this.port, this.path, this.queryMap);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public DefaultNConnectionStringBuilder setPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public DefaultNConnectionStringBuilder setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Override
    public String getQueryString() {
        return DefaultNConnectionStringBuilder.serializeQueryMap(this.queryMap);
    }

    @Override
    public NConnectionStringBuilder setQueryString(String queryString) {
        this.queryMap = DefaultNConnectionStringBuilder.deserializeQueryMap(queryString);
        return this;
    }

    @Override
    public NConnectionStringBuilder setQueryParam(String param, String value) {
        if (param == null) {
            param = "";
        }
        if (value == null) {
            if (this.queryMap != null) {
                this.queryMap.remove(param);
            }
        } else if (this.queryMap == null) {
            this.queryMap = new LinkedHashMap<String, List<String>>();
            ArrayList<String> a = new ArrayList<String>();
            a.add(value);
            this.queryMap.put(param, a);
        } else {
            List a = this.queryMap.computeIfAbsent(param, n -> new ArrayList());
            if (a.size() != 1 || !Objects.equals(value, a.get(0))) {
                if (a.isEmpty()) {
                    a.add(value);
                } else {
                    a.clear();
                    a.add(value);
                }
            }
        }
        return this;
    }

    @Override
    public NConnectionStringBuilder addQueryParam(String param, String value) {
        if (param == null) {
            param = "";
        }
        if (value == null) {
            return this;
        }
        if (this.queryMap == null) {
            this.queryMap = new LinkedHashMap<String, List<String>>();
            ArrayList<String> a = new ArrayList<String>();
            a.add(value);
            this.queryMap.put(param, a);
        } else {
            List a = this.queryMap.computeIfAbsent(param, n -> new ArrayList());
            a.add(value);
        }
        return this;
    }

    @Override
    public NConnectionStringBuilder addUniqueQueryParam(String param, String value) {
        if (param == null) {
            param = "";
        }
        if (value == null) {
            return this;
        }
        if (this.queryMap == null) {
            this.queryMap = new LinkedHashMap<String, List<String>>();
            ArrayList<String> a = new ArrayList<String>();
            a.add(value);
            this.queryMap.put(param, a);
        } else {
            List a = this.queryMap.computeIfAbsent(param, n -> new ArrayList());
            if (!a.contains(value)) {
                a.add(value);
            }
        }
        return this;
    }

    @Override
    public NConnectionStringBuilder clearQueryParam(String param) {
        if (param == null) {
            param = "";
        }
        if (this.queryMap != null) {
            this.queryMap.remove(param);
        }
        return this;
    }

    @Override
    public NOptional<String> getQueryParam(String param) {
        if (param == null) {
            param = "";
        }
        String finalParam = param;
        return NOptional.ofFirst(this.getQueryParams(param), () -> NMsg.ofC("missing '%s'", finalParam));
    }

    @Override
    public List<String> getQueryParams(String param) {
        if (this.queryMap != null) {
            List<String> all;
            if (param == null) {
                param = "";
            }
            if ((all = this.queryMap.get(param)) != null) {
                return new ArrayList<String>(all);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public NConnectionStringBuilder setNormalized(boolean normalized) {
        this.normalized = normalized;
        return this;
    }

    @Override
    public boolean isNormalized() {
        return this.normalized;
    }

    @Override
    public DefaultNConnectionStringBuilder copy() {
        try {
            DefaultNConnectionStringBuilder c = (DefaultNConnectionStringBuilder)this.clone();
            c.queryMap = DefaultNConnectionStringBuilder.prepareQueryMap(this.queryMap, false);
            return c;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<String> getNames() {
        return NStringUtils.split(this.path, "/", true, true).stream().map(s -> s).collect(Collectors.toList());
    }

    private static String safeUrlDecode(String s) {
        try {
            return URLDecoder.decode(s == null ? "" : s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String safeUrlEncode(String s) {
        try {
            return URLEncoder.encode(s == null ? "" : s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public DefaultNConnectionStringBuilder resolve(String child) {
        if (!NBlankable.isBlank(child)) {
            return this.copy().setPath(NStringUtils.pjoin("/", this.path, child));
        }
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }
}

