/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.net;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.net.DefaultNConnectionStringBuilder;
import net.thevpc.nuts.net.NConnectionString;
import net.thevpc.nuts.net.NConnectionStringBuilder;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNConnectionString
implements NConnectionString {
    private String protocol;
    private String userName;
    private String password;
    private String host;
    private String port;
    private String path;
    private String queryString;
    private Map<String, List<String>> queryMap;

    public DefaultNConnectionString() {
        this.queryMap = Collections.emptyMap();
    }

    public DefaultNConnectionString(String protocol, String userName, String password, String host, String port, String path, Map<String, List<String>> queryMap) {
        this.protocol = protocol;
        this.userName = userName;
        this.password = password;
        this.host = host;
        this.port = port;
        this.path = path;
        this.queryMap = DefaultNConnectionStringBuilder.prepareQueryMap(queryMap, false);
        this.queryString = DefaultNConnectionStringBuilder.serializeQueryMap(this.queryMap);
    }

    public DefaultNConnectionString(String protocol, String userName, String password, String host, String port, String path, String queryString) {
        this.protocol = protocol;
        this.userName = userName;
        this.password = password;
        this.host = host;
        this.port = port;
        this.path = path;
        this.queryString = queryString;
        this.queryMap = DefaultNConnectionStringBuilder.deserializeQueryMap(queryString);
    }

    @Override
    public NConnectionString normalize() {
        return this.builder().setNormalized(true).build();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNConnectionString that = (DefaultNConnectionString)o;
        return Objects.equals(this.protocol, that.protocol) && Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && Objects.equals(this.path, that.path) && Objects.equals(this.queryString, that.queryString) && Objects.equals(this.queryMap, that.queryMap);
    }

    public int hashCode() {
        return Objects.hash(this.protocol, this.userName, this.password, this.host, this.port, this.path, this.queryString, this.queryMap);
    }

    @Override
    public NConnectionStringBuilder builder() {
        return new DefaultNConnectionStringBuilder(this);
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public NOptional<Map<String, List<String>>> getQueryMap() {
        return NOptional.ofNamed(this.queryMap, "queryMap");
    }

    @Override
    public NConnectionString getRoot() {
        return this.builder().setPath("/").build();
    }

    @Override
    public NConnectionString getParent() {
        String ppath = this.path;
        if (NBlankable.isBlank(ppath) || "/".equals(ppath)) {
            return null;
        }
        while (ppath.endsWith("/")) {
            ppath = ppath.substring(0, ppath.length() - 1);
        }
        if (ppath.isEmpty()) {
            return this.builder().setPath("/").build();
        }
        int i = ppath.lastIndexOf(47);
        ppath = i <= 0 ? "/" : ppath.substring(0, i + 1);
        return this.builder().setPath(ppath).build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean fileProtocol = "file".equals(this.protocol);
        if (!NBlankable.isBlank(this.protocol)) {
            sb.append(DefaultNConnectionString.safeUrlEncode(NStringUtils.trim(this.protocol))).append(":");
            if (!fileProtocol) {
                sb.append("//");
                if (!NBlankable.isBlank(this.userName)) {
                    sb.append(DefaultNConnectionString.safeUrlEncode(NStringUtils.trim(this.userName)));
                    if (!NBlankable.isBlank(DefaultNConnectionString.safeUrlEncode(this.password))) {
                        sb.append(':');
                        sb.append(DefaultNConnectionString.safeUrlEncode(this.password));
                    }
                    sb.append('@');
                }
                if (NBlankable.isBlank(this.host)) {
                    sb.append("localhost");
                } else {
                    sb.append(NStringUtils.trim(this.host));
                }
                if (!NBlankable.isBlank(this.port)) {
                    sb.append(":");
                    sb.append(DefaultNConnectionString.safeUrlEncode(this.port));
                }
            }
        } else {
            if (!NBlankable.isBlank(this.userName)) {
                sb.append(DefaultNConnectionString.safeUrlEncode(NStringUtils.trim(this.userName)));
                if (!NBlankable.isBlank(this.password)) {
                    sb.append(':');
                    sb.append(DefaultNConnectionString.safeUrlEncode(this.password));
                }
                if (!NBlankable.isBlank(this.host) || !NBlankable.isBlank(this.port)) {
                    sb.append('@');
                }
            }
            if (!NBlankable.isBlank(this.host) || !NBlankable.isBlank(this.port)) {
                if (NBlankable.isBlank(this.host)) {
                    sb.append("localhost");
                } else {
                    sb.append(DefaultNConnectionString.safeUrlEncode(NStringUtils.trim(this.host)));
                }
                if (!NBlankable.isBlank(this.port)) {
                    sb.append(":");
                    sb.append(DefaultNConnectionString.safeUrlEncode(this.port));
                }
            }
        }
        if (!NBlankable.isBlank(this.path)) {
            if (!(fileProtocol || sb.length() != 0 && sb.charAt(sb.length() - 1) == '/' || this.path.charAt(0) == '/')) {
                sb.append('/');
            }
            sb.append(this.path);
        }
        if (!NBlankable.isBlank(this.queryString)) {
            sb.append("?").append(this.queryString);
        }
        return sb.toString();
    }

    @Override
    public List<String> getNames() {
        return NStringUtils.split(this.path, "/", true, true).stream().map(s -> s).collect(Collectors.toList());
    }

    private static String safeUrlDecode(String s) {
        try {
            return URLDecoder.decode(s == null ? "" : s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String safeUrlEncode(String s) {
        try {
            return URLEncoder.encode(s == null ? "" : s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public NConnectionString resolve(String child) {
        if (!NBlankable.isBlank(child)) {
            return this.builder().setPath(NStringUtils.pjoin("/", this.path, child)).build();
        }
        return this;
    }

    @Override
    public NConnectionString withPath(String path) {
        return this.builder().setPath(path).build();
    }
}

