/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.math;

import java.io.Serializable;
import java.util.Objects;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public class NDoubleComplex
extends Number
implements Serializable,
Comparable<NDoubleComplex> {
    public static final NDoubleComplex ZERO = new NDoubleComplex(0.0, 0.0);
    public static final NDoubleComplex ONE = new NDoubleComplex(1.0, 0.0);
    public static final NDoubleComplex I = new NDoubleComplex(0.0, 1.0);
    private double real;
    private double imag;

    public NOptional<NDoubleComplex> of(String any) {
        try {
            if (NBlankable.isBlank(any)) {
                return NOptional.ofNamedEmpty("complex");
            }
            any = any.trim();
            String[] c = NReservedUtils.parseComplexStrings(any);
            return NOptional.of(new NDoubleComplex(Double.parseDouble(c[0]), Double.parseDouble(c[1])));
        }
        catch (Exception e) {
            return NOptional.ofNamedError("complex : " + any);
        }
    }

    public NDoubleComplex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public double real() {
        return this.real;
    }

    public double imag() {
        return this.imag;
    }

    public double abs() {
        return Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    @Override
    public double doubleValue() {
        return this.real;
    }

    @Override
    public int intValue() {
        return (int)this.doubleValue();
    }

    @Override
    public long longValue() {
        return (long)this.doubleValue();
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NDoubleComplex ndComplex = (NDoubleComplex)o;
        return Double.compare(this.real, ndComplex.real) == 0 && Double.compare(this.imag, ndComplex.imag) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.real, this.imag);
    }

    public String toString() {
        if (this.imag == 0.0) {
            return this.realToString(this.real);
        }
        if (this.real == 0.0) {
            return this.imagToString(this.imag);
        }
        if (this.imag < 0.0) {
            return this.realToString(this.real) + this.imagToString(this.imag);
        }
        return this.realToString(this.real) + "+" + this.imagToString(this.imag);
    }

    protected String realToString(double d) {
        return String.valueOf(d);
    }

    protected String imagToString(double d) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return d + "*\u00ee";
        }
        if (d == 1.0) {
            return "\u00ee";
        }
        if (d == -1.0) {
            return "-\u00ee";
        }
        return d + "\u00ee";
    }

    @Override
    public int compareTo(NDoubleComplex other) {
        boolean otherNaN;
        boolean thisNaN = Double.isNaN(this.real) || Double.isNaN(this.imag);
        boolean bl = otherNaN = Double.isNaN(other.real) || Double.isNaN(other.imag);
        if (thisNaN && otherNaN) {
            return 0;
        }
        if (thisNaN) {
            return 1;
        }
        if (otherNaN) {
            return -1;
        }
        double mag1 = this.real * this.real + this.imag * this.imag;
        double mag2 = other.real * other.real + other.imag * other.imag;
        if (mag1 < mag2) {
            return -1;
        }
        if (mag1 > mag2) {
            return 1;
        }
        int cmpReal = Double.compare(this.real, other.real);
        if (cmpReal != 0) {
            return cmpReal;
        }
        return Double.compare(this.imag, other.imag);
    }

    public NDoubleComplex add(NDoubleComplex other) {
        return new NDoubleComplex(this.real + other.real, this.imag + other.imag);
    }

    public NDoubleComplex negate() {
        return new NDoubleComplex(-this.real, -this.imag);
    }

    public NDoubleComplex subtract(NDoubleComplex other) {
        return new NDoubleComplex(this.real - other.real, this.imag - other.imag);
    }

    public NDoubleComplex multiply(NDoubleComplex z2) {
        double real = this.real * z2.real - this.imag * z2.imag;
        double imag = this.real * z2.imag + this.imag * z2.real;
        return new NDoubleComplex(real, imag);
    }

    public NDoubleComplex divide(NDoubleComplex other) {
        double c = other.real;
        double d = other.imag;
        double denominator = c * c + d * d;
        return new NDoubleComplex((this.real * c + this.imag * d) / denominator, (this.imag * c - this.real * d) / denominator);
    }

    public NDoubleComplex inv() {
        double denominator = this.real * this.real + this.imag * this.imag;
        return new NDoubleComplex(this.real / denominator, -this.imag / denominator);
    }
}

