/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.log;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.util.NAssert;

public final class NMsgIntent {
    private static final Map<String, NMsgIntent> cached = new HashMap<String, NMsgIntent>();
    public static final NMsgIntent NOTICE = NMsgIntent.of("NOTICE");
    public static final NMsgIntent DEBUG = NMsgIntent.of("DEBUG");
    public static final NMsgIntent START = NMsgIntent.of("START");
    public static final NMsgIntent SUCCESS = NMsgIntent.of("SUCCESS");
    public static final NMsgIntent ALERT = NMsgIntent.of("ALERT");
    public static final NMsgIntent INIT = NMsgIntent.of("INIT");
    public static final NMsgIntent DISPOSE = NMsgIntent.of("DISPOSE");
    public static final NMsgIntent FAIL = NMsgIntent.of("FAIL");
    public static final NMsgIntent READ = NMsgIntent.of("READ");
    public static final NMsgIntent UPDATE = NMsgIntent.of("UPDATE");
    public static final NMsgIntent ADD = NMsgIntent.of("ADD");
    public static final NMsgIntent REMOVE = NMsgIntent.of("REMOVE");
    public static final NMsgIntent CACHE = NMsgIntent.of("CACHE");
    public static final NMsgIntent PROGRESS = NMsgIntent.of("PROGRESS");
    private final String name;

    public NMsgIntent(String name) {
        NAssert.requireNonBlank(name, "log verb");
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NMsgIntent of(String name) {
        NMsgIntent t = cached.get(name);
        if (t == null) {
            Map<String, NMsgIntent> map = cached;
            synchronized (map) {
                t = cached.get(name);
                if (t == null) {
                    t = new NMsgIntent(name);
                    cached.put(name, t);
                }
            }
        }
        return t;
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NMsgIntent that = (NMsgIntent)o;
        return Objects.equals(this.name, that.name);
    }

    public String toString() {
        return this.name;
    }
}

