/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.log;

import java.io.Serializable;
import java.util.Objects;
import java.util.logging.Level;

public class NLogConfig
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public static NLogConfig BLANK = new NLogConfig().readOnly();
    private Level logFileLevel = Level.OFF;
    private Level logTermLevel = Level.OFF;
    private int logFileSize = 0;
    private int logFileCount = 0;
    private String logFileName = null;
    private String logFileBase = null;
    private boolean readOnly;

    public NLogConfig() {
    }

    public NLogConfig(NLogConfig other, boolean readOnly) {
        this.readOnly = readOnly;
        if (other != null) {
            this.logFileLevel = other.logFileLevel;
            this.logTermLevel = other.logTermLevel;
            this.logFileSize = other.logFileSize;
            this.logFileCount = other.logFileCount;
            this.logFileName = other.logFileName;
            this.logFileBase = other.logFileBase;
        }
    }

    public Level getLogFileLevel() {
        return this.logFileLevel;
    }

    public NLogConfig setLogFileLevel(Level logFileLevel) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileLevel = logFileLevel;
        return this;
    }

    public Level getLogTermLevel() {
        return this.logTermLevel;
    }

    public NLogConfig setLogTermLevel(Level logTermLevel) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logTermLevel = logTermLevel;
        return this;
    }

    public int getLogFileSize() {
        return this.logFileSize;
    }

    public NLogConfig setLogFileSize(int logFileSize) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileSize = logFileSize;
        return this;
    }

    public int getLogFileCount() {
        return this.logFileCount;
    }

    public NLogConfig setLogFileCount(int logFileCount) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileCount = logFileCount;
        return this;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public NLogConfig setLogFileName(String logFileName) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileName = logFileName;
        return this;
    }

    public String getLogFileBase() {
        return this.logFileBase;
    }

    public NLogConfig setLogFileBase(String logFileBase) {
        if (this.readOnly) {
            throw new IllegalArgumentException("read only");
        }
        this.logFileBase = logFileBase;
        return this;
    }

    public NLogConfig copy() {
        return new NLogConfig(this, false);
    }

    public NLogConfig readOnly() {
        if (this.readOnly) {
            return this;
        }
        return new NLogConfig(this, true);
    }

    public int hashCode() {
        return Objects.hash(this.logFileLevel, this.logTermLevel, this.logFileSize, this.logFileCount, this.logFileName, this.logFileBase);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NLogConfig that = (NLogConfig)o;
        return this.logFileSize == that.logFileSize && this.logFileCount == that.logFileCount && Objects.equals(this.logFileLevel, that.logFileLevel) && Objects.equals(this.logTermLevel, that.logTermLevel) && Objects.equals(this.logFileName, that.logFileName) && Objects.equals(this.logFileBase, that.logFileBase);
    }

    public String toString() {
        return "NutsLogConfig{logFileLevel=" + this.logFileLevel + ", logTermLevel=" + this.logTermLevel + ", logFileSize=" + this.logFileSize + ", logFileCount=" + this.logFileCount + ", logFileName='" + this.logFileName + '\'' + ", logFileBase='" + this.logFileBase + '\'' + ", readOnly=" + this.readOnly + '}';
    }
}

