/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.log;

import java.util.function.Supplier;
import java.util.logging.Level;
import net.thevpc.nuts.log.NLogSPI;
import net.thevpc.nuts.log.NLogs;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NMsgBuilder;
import net.thevpc.nuts.util.NAssert;

public interface NLog {
    public String getName();

    public static NLog of(Class<?> clazz) {
        return NLog.of(NAssert.requireNonBlank(clazz, "class").getName());
    }

    public static NLog ofNull() {
        return NLogs.of().getNullLogger();
    }

    public static NLog ofScoped(Class<?> clazz) {
        return NLog.ofScoped(NAssert.requireNonBlank(clazz, "class").getName());
    }

    public static NLog of(String name) {
        return NLogs.of().getLogger(name);
    }

    public static NLog of(String name, NLogSPI spi) {
        return NLogs.of().createCustomLogger(name, spi);
    }

    public static NLog of(NLogSPI spi) {
        return NLogs.of().createCustomLogger(null, spi);
    }

    public static NLog ofScoped(String name) {
        return NLog.of(name).scoped();
    }

    public boolean isLoggable(Level var1);

    public NLog scoped();

    default public void info(NMsg msg) {
        this.log(msg.asInfo());
    }

    default public void debug(NMsg msg) {
        this.log(msg.asDebug());
    }

    default public void warn(NMsg msg) {
        this.log(msg.asWarningAlert());
    }

    default public void error(NMsg msg) {
        this.log(msg.asError());
    }

    public void log(Level var1, Supplier<NMsg> var2);

    public void log(NMsg var1);

    public void log(NMsgBuilder var1);
}

