/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import net.thevpc.nuts.internal.rpi.NIORPI;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.io.NContentMetadataProvider;
import net.thevpc.nuts.io.NInputContentProvider;
import net.thevpc.nuts.io.NInputStreamProvider;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NReaderProvider;
import net.thevpc.nuts.util.NStream;

public interface NInputSource
extends NContentMetadataProvider,
NInputContentProvider {
    public static NInputSource of(File file) {
        return file == null ? null : NPath.of(file);
    }

    public static NInputSource of(Path file) {
        return file == null ? null : NPath.of(file);
    }

    public static NInputSource of(URL file) {
        return file == null ? null : NPath.of(file);
    }

    public static NInputSource of(byte[] bytes) {
        return bytes == null ? null : NIORPI.of().ofInputSource(bytes);
    }

    public static NInputSource ofEmpty() {
        return NIORPI.of().ofEmptyInputSource();
    }

    public static NInputSource of(InputStream inputSource) {
        return inputSource == null ? null : NIORPI.of().ofInputSource(inputSource);
    }

    public static NInputSource ofMultiRead(NInputSource source) {
        return source == null ? null : NIORPI.of().ofMultiRead(source);
    }

    public static NInputSource of(InputStream inputStream, NContentMetadata metadata) {
        return inputStream == null ? null : NIORPI.of().ofInputSource(inputStream, metadata);
    }

    public static NInputSource of(Reader reader, NContentMetadata metadata) {
        return reader == null ? null : NIORPI.of().ofInputSource(reader, metadata);
    }

    public static NInputSource of(Reader reader) {
        return reader == null ? null : NIORPI.of().ofInputSource(reader);
    }

    public static NInputSource of(byte[] bytes, NContentMetadata metadata) {
        return bytes == null ? null : NIORPI.of().ofInputSource(bytes, metadata);
    }

    public static NInputSource of(NInputStreamProvider other) {
        return NInputSource.of(other, null);
    }

    public static NInputSource of(NInputStreamProvider other, NContentMetadata metadata) {
        return other == null ? null : (other instanceof NInputSource && metadata == null ? (NInputSource)other : NIORPI.of().ofInputSource(other, metadata));
    }

    public static NInputSource of(NReaderProvider other) {
        return NInputSource.of(other, null);
    }

    public static NInputSource of(NReaderProvider other, NContentMetadata metadata) {
        return other == null ? null : (other instanceof NInputSource && metadata == null ? (NInputSource)((Object)other) : NIORPI.of().ofInputSource(other, metadata));
    }

    public byte[] readBytes();

    default public String readString() {
        return new String(this.readBytes());
    }

    default public String readString(Charset cs) {
        return cs == null ? new String(this.readBytes()) : new String(this.readBytes(), cs);
    }

    public boolean isMultiRead();

    public boolean isKnownContentLength();

    public long getContentLength();

    public NStream<String> lines(Charset var1);

    public NStream<String> lines();

    public NStream<String> reversedLines(Charset var1);

    public NStream<String> reversedLines();

    public Reader getReader();

    public Reader getReader(Charset var1);

    public BufferedReader getBufferedReader();

    public BufferedReader getBufferedReader(Charset var1);

    public List<String> head(int var1, Charset var2);

    public List<String> head(int var1);

    public List<String> tail(int var1, Charset var2);

    public List<String> tail(int var1);

    default public void dispose() {
    }

    public byte[] getDigest();

    public byte[] getDigest(String var1);

    public String getDigestString();

    public String getDigestString(String var1);
}

