/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NPathExtensionType;
import net.thevpc.nuts.io.NPathNameParts;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnexpectedException;

public class NIOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 40960;

    public static String normalizePath(String names) {
        String string = String.join((CharSequence)"/", NIOUtils.normalizePathNames(NStringUtils.split(names, "/\\", false, true)));
        if (names != null && (names.startsWith("/") || names.startsWith("\\"))) {
            return "/" + string;
        }
        return string;
    }

    public static List<String> normalizePathNames(List<String> names) {
        ArrayList<String> newNames = new ArrayList<String>();
        Iterator<String> iterator = names.iterator();
        block8: while (iterator.hasNext()) {
            String item;
            switch (item = iterator.next()) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (newNames.size() <= 0) continue block8;
                    newNames.remove(newNames.size() - 1);
                    continue block8;
                }
            }
            newNames.add(item);
        }
        return newNames;
    }

    public static String toRelativePath(String child, String parent) {
        if (child.startsWith(parent)) {
            if ((child = child.substring(parent.length())).startsWith("/") || child.startsWith("\\")) {
                child = child.substring(1);
            }
            if (child.isEmpty()) {
                return "/";
            }
            return child;
        }
        return null;
    }

    public static boolean isValidFileNameChar(char c) {
        switch (c) {
            case '\"': 
            case '$': 
            case '%': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '/': 
            case ':': 
            case '<': 
            case '>': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '`': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
        }
        return c >= ' ';
    }

    public static String normalizeFileName(String name) {
        char[] chars = NStringUtils.normalizeString(name).toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '\u00b0': {
                    chars[i] = 111;
                    continue block4;
                }
                case '\"': 
                case '$': 
                case '%': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '`': 
                case '{': 
                case '|': 
                case '}': {
                    chars[i] = 32;
                    continue block4;
                }
                default: {
                    if (chars[i] >= ' ') continue block4;
                    chars[i] = 32;
                }
            }
        }
        return new String(chars).trim();
    }

    public static long copy(Reader in, Writer out) {
        return NIOUtils.copy(in, out, 40960);
    }

    public static long copy(InputStream in, OutputStream out) {
        return NIOUtils.copy(in, out, 40960);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) {
        if (bufferSize <= 0) {
            bufferSize = 40960;
        }
        byte[] buffer = new byte[bufferSize];
        long count = 0L;
        try {
            int len;
            while ((len = in.read(buffer)) > 0) {
                count += (long)len;
                out.write(buffer, 0, len);
            }
            return len;
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public static long copy(Reader in, Writer out, int bufferSize) {
        if (bufferSize <= 0) {
            bufferSize = 40960;
        }
        char[] buffer = new char[bufferSize];
        long count = 0L;
        try {
            int len;
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
                count += (long)len;
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(InputStream is, boolean close) {
        String string;
        block6: {
            try {
                byte[] bytes = NIOUtils.loadByteArray(is);
                string = new String(bytes);
                if (is == null || !close) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null && close) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(Reader is, boolean close) {
        String string;
        block6: {
            try {
                char[] bytes = NIOUtils.loadCharArray(is);
                string = new String(bytes);
                if (is == null || !close) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null && close) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            is.close();
        }
        return string;
    }

    public static char[] loadCharArray(Reader r) {
        try (CharArrayWriter out = null;){
            out = new CharArrayWriter();
            NIOUtils.copy(r, out);
            out.flush();
            char[] cArray = out.toCharArray();
            return cArray;
        }
    }

    public static byte[] loadByteArray(InputStream r) {
        byte[] byArray;
        block6: {
            ByteArrayOutputStream out = null;
            try {
                out = new ByteArrayOutputStream();
                NIOUtils.copy(r, out);
                out.flush();
                byArray = out.toByteArray();
                if (out == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            out.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadByteArray(InputStream r, boolean close) {
        byte[] byArray;
        block8: {
            ByteArrayOutputStream out = null;
            try {
                out = new ByteArrayOutputStream();
                NIOUtils.copy(r, out);
                out.flush();
                byArray = out.toByteArray();
                if (out == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (r != null && close) {
                        r.close();
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                }
            }
            out.close();
        }
        if (r != null && close) {
            r.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] loadByteArray(InputStream stream, int maxSize, boolean close) {
        try {
            try {
                if (maxSize > 0) {
                    int count;
                    ByteArrayOutputStream to = new ByteArrayOutputStream();
                    byte[] bytes = new byte[Math.max(maxSize, 10240)];
                    int all = 0;
                    while ((count = stream.read(bytes)) > 0) {
                        if (all + count < maxSize) {
                            to.write(bytes, 0, count);
                            all += count;
                            continue;
                        }
                        int count2 = maxSize - all;
                        to.write(bytes, 0, count2);
                        all += count2;
                        break;
                    }
                    byte[] byArray2 = to.toByteArray();
                    return byArray2;
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                NIOUtils.copy(stream, os, close, true);
                byte[] byArray = os.toByteArray();
                return byArray;
            }
            finally {
                if (close) {
                    stream.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public static long copy(InputStream from, OutputStream to, boolean closeInput, boolean closeOutput) {
        byte[] bytes = new byte[1024];
        long all = 0L;
        try {
            try {
                long l;
                block11: {
                    try {
                        int count;
                        while ((count = from.read(bytes)) > 0) {
                            to.write(bytes, 0, count);
                            all += (long)count;
                        }
                        l = all;
                        if (!closeInput) break block11;
                    }
                    catch (Throwable throwable) {
                        if (closeInput) {
                            from.close();
                        }
                        throw throwable;
                    }
                    from.close();
                }
                return l;
            }
            finally {
                if (closeOutput) {
                    to.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public static void delete(File file) {
        NIOUtils.delete(file.toPath());
    }

    public static void delete(Path file) {
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try {
                Files.delete(file);
            }
            catch (IOException e) {
                return;
            }
        }
        final int[] deleted = new int[]{0, 0, 0};
        NSession session = NSession.get().orNull();
        final NLog LOG = session == null ? null : NLog.of(NIOUtils.class);
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                        if (LOG != null) {
                            LOG.log(NMsg.ofC("delete file %s", file).asFineAlert());
                        }
                        deleted[0] = deleted[0] + 1;
                    }
                    catch (IOException e) {
                        if (LOG != null) {
                            LOG.log(NMsg.ofC("failed deleting file : %s", file).asFineAlert());
                        }
                        deleted[2] = deleted[2] + 1;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    try {
                        Files.delete(dir);
                        if (LOG != null) {
                            LOG.log(NMsg.ofC("delete folder %s", dir).asFineAlert());
                        }
                        deleted[1] = deleted[1] + 1;
                    }
                    catch (IOException e) {
                        if (LOG != null) {
                            LOG.log(NMsg.ofC("failed deleting folder: %s", dir).asFineAlert());
                        }
                        deleted[2] = deleted[2] + 1;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    public static NPathNameParts getPathNameParts(String name, NPathExtensionType type) {
        if (type == null || type == NPathExtensionType.SMART) {
            type = NPathExtensionType.LONG;
        }
        switch (type) {
            case LONG: {
                String n = name == null ? "" : name;
                int i = n.indexOf(46);
                if (i < 0) {
                    return new NPathNameParts(n, "", "", NPathExtensionType.LONG);
                }
                return new NPathNameParts(n.substring(0, i), n.substring(i + 1), n.substring(i), NPathExtensionType.LONG);
            }
            case SHORT: {
                String n = name == null ? "" : name;
                int i = n.lastIndexOf(46);
                if (i < 0) {
                    return new NPathNameParts(n, "", "", NPathExtensionType.SHORT);
                }
                return new NPathNameParts(n.substring(0, i), n.substring(i + 1), n.substring(i), NPathExtensionType.SHORT);
            }
        }
        throw new NUnexpectedException(NMsg.ofC("%s not supported", type));
    }

    public static String getFileExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i == 0) {
            return s.substring(1);
        }
        if (i > 0) {
            if (i < s.length() - 1) {
                return s.substring(i + 1);
            }
            return "";
        }
        return "";
    }

    public static String getFileExtension(String s, boolean longest, boolean includeDot) {
        int i;
        int n = i = longest ? s.indexOf(46) : s.lastIndexOf(46);
        if (i == 0) {
            return includeDot ? s : s.substring(1);
        }
        if (i > 0) {
            if (i < s.length() - 1) {
                return s.substring(includeDot ? i : i + 1);
            }
            return "";
        }
        return "";
    }

    public static boolean isURL(String url) {
        try {
            URI.create(url).toURL();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static byte[] charsToBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }

    public static char[] bytesToChars(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
        char[] chars = Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit());
        Arrays.fill(charBuffer.array(), '\u0000');
        return chars;
    }

    public static boolean isAbsolutePath(String location) {
        return new File(location).isAbsolute();
    }

    public static String getAbsolutePath(String path) {
        return new File(path).toPath().toAbsolutePath().normalize().toString();
    }

    public static void copyFolder(Path src, Path dest) {
        try {
            Files.walk(src, new FileVisitOption[0]).forEach(source -> NIOUtils.copy(source, dest.resolve(src.relativize((Path)source))));
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
    }

    private static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new NIOException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean compareContent(Path file1, Path file2) {
        block15: {
            if (Files.isRegularFile(file1, new LinkOption[0]) && Files.isRegularFile(file2, new LinkOption[0])) {
                try {
                    if (Files.size(file1) != Files.size(file2)) break block15;
                    try (InputStream in1 = Files.newInputStream(file1, new OpenOption[0]);){
                        boolean bl;
                        block16: {
                            InputStream in2 = Files.newInputStream(file1, new OpenOption[0]);
                            try {
                                bl = NIOUtils.compareContent(in1, in2);
                                if (in2 == null) break block16;
                            }
                            catch (Throwable throwable) {
                                if (in2 != null) {
                                    try {
                                        in2.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            in2.close();
                        }
                        return bl;
                    }
                }
                catch (IOException e) {
                    throw new NIOException(e);
                }
            }
        }
        return false;
    }

    public static boolean compareContent(InputStream in1, InputStream in2) {
        int c1;
        int max = 2048;
        byte[] b1 = new byte[max];
        byte[] b2 = new byte[max];
        do {
            int c2;
            if ((c1 = NIOUtils.readBestEffort(b1, 0, b1.length, in1)) != (c2 = NIOUtils.readBestEffort(b2, 0, b2.length, in2))) {
                return false;
            }
            if (c1 == 0) {
                return true;
            }
            if (NIOUtils.Arrays_equals(b1, 0, c1, b2, 0, c1)) continue;
            return false;
        } while (c1 >= max);
        return true;
    }

    private static boolean Arrays_equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        for (int i = 0; i < aLength; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] readBestEffort(int len, InputStream in) {
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return new byte[0];
        }
        byte[] buf = new byte[len];
        int count = NIOUtils.readBestEffort(buf, 0, len, in);
        if (count == len) {
            return buf;
        }
        byte[] buf2 = new byte[count];
        System.arraycopy(buf, 0, buf2, 0, count);
        return buf2;
    }

    public static int readBestEffort(byte[] b, int off, int len, InputStream in) {
        int n;
        int count;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (n = 0; n < len; n += count) {
            count = 0;
            try {
                count = in.read(b, off + n, len - n);
            }
            catch (IOException e) {
                throw new NIOException(e);
            }
            if (count < 0) break;
        }
        return n;
    }

    public static byte[] readBytes(File file) {
        byte[] byArray;
        FileInputStream in = new FileInputStream(file);
        try {
            byArray = NIOUtils.readBytes(in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        ((InputStream)in).close();
        return byArray;
    }

    public static byte[] readBytes(Path file) {
        byte[] byArray;
        block8: {
            InputStream in = Files.newInputStream(file, new OpenOption[0]);
            try {
                byArray = NIOUtils.readBytes(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            in.close();
        }
        return byArray;
    }

    public static byte[] readBytes(URL url) {
        byte[] byArray;
        block8: {
            InputStream in = url.openStream();
            try {
                byArray = NIOUtils.readBytes(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }
            in.close();
        }
        return byArray;
    }

    public static String readString(InputStream from) {
        return new String(NIOUtils.readBytes(from));
    }

    public static String readString(Reader from) {
        return new String(NIOUtils.readChars(from));
    }

    public static byte[] readBytes(InputStream from) {
        return NIOUtils.readBytes(from, -1);
    }

    public static byte[] readBytes(InputStream from, int bufferSize) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        NIOUtils.copy(from, out, bufferSize);
        return out.toByteArray();
    }

    public static char[] readChars(Reader from) {
        return NIOUtils.readChars(from, -1);
    }

    public static char[] readChars(Reader from, int bufferSize) {
        CharArrayWriter out = new CharArrayWriter();
        NIOUtils.copy(from, out, bufferSize);
        return out.toCharArray();
    }

    public static String readString(File file) {
        try {
            return new String(Files.readAllBytes(file.toPath()));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static String readString(Path file) {
        try {
            return new String(Files.readAllBytes(file));
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static void copy(InputStream in, Path file) {
        Path p = file.getParent();
        if (p != null) {
            p.toFile().mkdirs();
        }
        try (OutputStream out = Files.newOutputStream(file, new OpenOption[0]);){
            NIOUtils.copy(in, out);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public static void copy(Reader in, Path file) {
        Path p = file.getParent();
        if (p != null) {
            p.toFile().mkdirs();
        }
        try (BufferedWriter out = Files.newBufferedWriter(file, new OpenOption[0]);){
            NIOUtils.copy(in, out);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

