/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.OutputStream;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NRedirectType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;

public class NExecOutput {
    private NRedirectType type;
    private OutputStream stream;
    private NPath path;
    private NPathOption[] options;
    private NInputSource result;

    public static NExecOutput ofNull() {
        return new NExecOutput(NRedirectType.NULL, null, null, null);
    }

    public static NExecOutput ofGrabMem() {
        return new NExecOutput(NRedirectType.GRAB_STREAM, null, null, null);
    }

    public static NExecOutput ofGrabFile() {
        return new NExecOutput(NRedirectType.GRAB_FILE, null, null, null);
    }

    public static NExecOutput ofInherit() {
        return new NExecOutput(NRedirectType.INHERIT, null, null, null);
    }

    public static NExecOutput ofRedirect() {
        return new NExecOutput(NRedirectType.REDIRECT, null, null, null);
    }

    public static NExecOutput ofStream(NPrintStream stream) {
        return stream == null ? NExecOutput.ofInherit() : NExecOutput.ofStream(stream.asOutputStream());
    }

    public static NExecOutput ofStream(OutputStream stream) {
        return stream == null ? NExecOutput.ofInherit() : new NExecOutput(NRedirectType.STREAM, stream, null, null);
    }

    public static NExecOutput ofPipe() {
        return new NExecOutput(NRedirectType.PIPE, null, null, null);
    }

    public static NExecOutput ofPath(NPath path, NPathOption ... options) {
        return path == null ? NExecOutput.ofInherit() : new NExecOutput(NRedirectType.PATH, null, path, options);
    }

    public static NExecOutput ofPath(NPath path, boolean append) {
        NExecOutput nExecOutput;
        if (path == null) {
            nExecOutput = NExecOutput.ofInherit();
        } else {
            NPathOption[] nPathOptionArray;
            if (append) {
                nPathOptionArray = null;
            } else {
                NPathOption[] nPathOptionArray2 = new NPathOption[1];
                nPathOptionArray = nPathOptionArray2;
                nPathOptionArray2[0] = NPathOption.APPEND;
            }
            nExecOutput = new NExecOutput(NRedirectType.PATH, null, path, nPathOptionArray);
        }
        return nExecOutput;
    }

    public static NExecOutput ofPath(NPath path) {
        return path == null ? NExecOutput.ofInherit() : new NExecOutput(NRedirectType.PATH, null, path, null);
    }

    private NExecOutput(NRedirectType type, OutputStream stream, NPath path, NPathOption[] options) {
        this.type = type;
        this.stream = stream;
        this.path = path;
        this.options = options == null ? new NPathOption[]{} : options;
    }

    public NRedirectType getType() {
        return this.type;
    }

    public NOptional<NInputSource> getResultSource() {
        switch (this.getType()) {
            case GRAB_STREAM: 
            case GRAB_FILE: {
                if (this.result != null) {
                    return NOptional.of(this.result);
                }
                return NOptional.ofEmpty(() -> NMsg.ofPlain("grabbed result is not available"));
            }
        }
        return NOptional.ofEmpty(() -> NMsg.ofPlain("no buffer was configured; should call setGrabOutString"));
    }

    public byte[] getResultBytes() {
        NInputSource s = null;
        try {
            s = this.getResultSource().get();
            byte[] byArray = s.readBytes();
            return byArray;
        }
        finally {
            if (s != null) {
                s.dispose();
            }
        }
    }

    public String getResultString() {
        return new String(this.getResultBytes());
    }

    public OutputStream getStream() {
        return this.stream;
    }

    public NPath getPath() {
        return this.path;
    }

    public NPathOption[] getOptions() {
        return this.options;
    }

    public NExecOutput setType(NRedirectType type) {
        this.type = type;
        return this;
    }

    public NExecOutput setStream(OutputStream stream) {
        this.stream = stream;
        return this;
    }

    public NExecOutput setPath(NPath path) {
        this.path = path;
        return this;
    }

    public NExecOutput setOptions(NPathOption[] options) {
        this.options = options;
        return this;
    }

    public NInputSource getResult() {
        return this.result;
    }

    public NExecOutput setResult(NInputSource result) {
        this.result = result;
        return this;
    }
}

