/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Objects;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NRedirectType;

public class NExecInput {
    private NRedirectType type;
    private InputStream stream;
    private NPath path;
    private NPathOption[] options;

    public static NExecInput ofNull() {
        return new NExecInput(NRedirectType.NULL, null, null, null);
    }

    public static NExecInput ofInherit() {
        return new NExecInput(NRedirectType.INHERIT, null, null, null);
    }

    public static NExecInput ofStream(InputStream stream) {
        return stream == null ? NExecInput.ofInherit() : new NExecInput(NRedirectType.STREAM, stream, null, null);
    }

    public static NExecInput ofBytes(byte[] bytes) {
        return bytes == null ? NExecInput.ofInherit() : new NExecInput(NRedirectType.STREAM, new ByteArrayInputStream(bytes), null, null);
    }

    public static NExecInput ofString(String string) {
        return string == null ? NExecInput.ofInherit() : new NExecInput(NRedirectType.STREAM, new ByteArrayInputStream(string.getBytes()), null, null);
    }

    public static NExecInput ofPipe() {
        return new NExecInput(NRedirectType.PIPE, null, null, null);
    }

    public static NExecInput ofPath(NPath path) {
        return path == null ? NExecInput.ofInherit() : new NExecInput(NRedirectType.PATH, null, path, null);
    }

    public static NExecInput ofPath(NPath file, NPathOption ... options) {
        if (file == null) {
            return NExecInput.ofInherit();
        }
        if (options == null || options.length == 0) {
            return NExecInput.ofPath(file);
        }
        if ((options = (NPathOption[])Arrays.stream(options).filter(Objects::nonNull).toArray(NPathOption[]::new)).length == 0) {
            return NExecInput.ofPath(file);
        }
        return NExecInput.ofStream(file.getInputStream(options));
    }

    private NExecInput(NRedirectType type, InputStream stream, NPath path, NPathOption[] options) {
        this.type = type;
        this.stream = stream;
        this.path = path;
        this.options = options == null ? new NPathOption[]{} : (NPathOption[])Arrays.stream(options).filter(Objects::nonNull).toArray(NPathOption[]::new);
    }

    public NRedirectType getType() {
        return this.type;
    }

    public InputStream getStream() {
        return this.stream;
    }

    public NPath getPath() {
        return this.path;
    }

    public NPathOption[] getOptions() {
        return this.options;
    }

    public String toString() {
        return "NExecInput{mode=" + this.type + ", stream=" + this.stream + ", path=" + this.path + ", options=" + Arrays.toString(this.options) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NExecInput that = (NExecInput)o;
        return this.type == that.type && Objects.equals(this.stream, that.stream) && Objects.equals(this.path, that.path) && Arrays.equals(this.options, that.options);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.stream, this.path);
        result = 31 * result + Arrays.hashCode(this.options);
        return result;
    }
}

