/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.io.NContentMetadataProvider;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public class NContentMetadataProviderFormatSPI
implements NFormatSPI {
    private NContentMetadataProvider p;
    private NMsg defaultMsg;
    private String defaultName;

    public NContentMetadataProviderFormatSPI(NContentMetadataProvider p, NMsg defaultMsg, String defaultName) {
        this.p = p;
        this.defaultName = defaultName;
        this.defaultMsg = defaultMsg;
    }

    @Override
    public String getName() {
        String name = this.p.getMetaData().getName().orNull();
        if (!NBlankable.isBlank(this.defaultMsg)) {
            name = this.defaultMsg.toString();
        }
        if (NBlankable.isBlank(name)) {
            name = this.defaultName;
        }
        if (NBlankable.isBlank(name)) {
            name = "no-name";
        }
        return name;
    }

    @Override
    public void print(NPrintStream out) {
        NOptional<NMsg> m = this.p.getMetaData().getMessage();
        if (m.isPresent()) {
            out.print(m.get());
        } else if (!NBlankable.isBlank(this.defaultMsg)) {
            out.print((Object)this.defaultMsg, NTextStyle.path());
        } else {
            out.print((Object)this.getClass().getSimpleName(), NTextStyle.path());
        }
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return false;
    }
}

