/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class NByteArrayQueue {
    private byte[] content;
    private int increment;
    private int from;
    private int to;
    private Map<String, Pattern> cachedPatterns = new HashMap<String, Pattern>();

    public NByteArrayQueue() {
        this(256);
    }

    public NByteArrayQueue(int initial) {
        this(initial, Math.min(initial, 256));
    }

    public NByteArrayQueue(int initial, int increment) {
        this.content = new byte[initial];
        this.increment = increment;
    }

    public int write(InputStream inputStream, int max) {
        byte[] all = new byte[max];
        int count = 0;
        try {
            count = inputStream.read(all);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (count > 0) {
            this.write(all, 0, count);
        }
        return count;
    }

    public synchronized void write(byte[] c) {
        this.write(c, 0, c.length);
    }

    public synchronized void write(byte[] c, int offset, int len) {
        this.ensureAvailable(len);
        System.arraycopy(c, offset, this.content, this.to, len);
        this.to += len;
    }

    public synchronized void write(byte c) {
        this.ensureAvailable(1);
        this.content[this.to++] = c;
    }

    public int length() {
        return this.to - this.from;
    }

    public byte peek() {
        if (this.to > this.from) {
            return this.content[this.from];
        }
        throw new UncheckedIOException(new EOFException());
    }

    public String peek(int count) {
        int c = this.length();
        if (count < c) {
            return new String(this.content, this.from, count);
        }
        return new String(this.content, this.from, c);
    }

    public boolean canRead() {
        return this.from < this.to;
    }

    public boolean canReadByCount(int count) {
        return this.from + count - 1 < this.to;
    }

    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int count) {
        if (this.from + count < this.to) {
            System.arraycopy(this.content, this.from, buffer, offset, count);
            this.from += count;
            return count;
        }
        count = this.to - this.from;
        System.arraycopy(this.content, this.from, buffer, offset, count);
        this.from = 0;
        this.to = 0;
        return count;
    }

    public byte[] read(int count) {
        if (this.from + count < this.to) {
            byte[] buffer = new byte[count];
            System.arraycopy(this.content, this.from, buffer, 0, count);
            this.from += count;
            return buffer;
        }
        byte[] r = new byte[this.to - this.from];
        System.arraycopy(this.content, this.from, r, 0, this.to - this.from);
        this.from = 0;
        this.to = 0;
        return r;
    }

    public void skip(int count) {
        if (this.from + count < this.to) {
            this.from += count;
        } else {
            this.from = 0;
            this.to = 0;
        }
    }

    public void clear() {
        this.from = 0;
        this.to = 0;
    }

    public byte read() {
        if (this.canRead()) {
            return this.content[this.from++];
        }
        throw new UncheckedIOException(new EOFException());
    }

    public void ensureAvailable(int z) {
        int currentEffLen = this.length();
        int newEffLen = currentEffLen + z;
        if (newEffLen > this.content.length) {
            byte[] n = new byte[newEffLen + this.increment];
            System.arraycopy(this.content, this.from, n, 0, currentEffLen);
            this.content = n;
            this.from = 0;
            this.to = currentEffLen;
            return;
        }
        int rightAvailable = this.content.length - this.to;
        if (z <= rightAvailable) {
            return;
        }
        System.arraycopy(this.content, this.from, this.content, 0, currentEffLen);
        this.from = 0;
        this.to = currentEffLen;
    }

    public String toString() {
        int c = this.length();
        return new String(this.content, this.from, c);
    }

    public byte byteAt(int index) {
        if (index >= 0 && index < this.length()) {
            return this.content[this.from + index];
        }
        throw new IndexOutOfBoundsException("invalid index " + index);
    }

    public boolean hasNext() {
        return this.to > this.from;
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    public int getAllocatedSize() {
        return this.content.length;
    }
}

