/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.util.List;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTextStyles;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NColor;
import net.thevpc.nuts.util.NLiteral;

public class NAnsiTermHelper {
    private static final int[] FG8 = new int[]{30, 31, 32, 33, 34, 35, 36, 37, 90, 91, 92, 93, 94, 95, 96, 97};
    private static final int[] BG8 = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 100, 101, 102, 103, 104, 105, 106, 107};

    public static NAnsiTermHelper of() {
        return new NAnsiTermHelper();
    }

    public String plain() {
        return "\u001b[0m";
    }

    public String styled(NTextStyles styles) {
        NColor foreground = null;
        NColor background = null;
        boolean bold = false;
        boolean blink = false;
        boolean underlined = false;
        boolean striked = false;
        boolean italic = false;
        boolean reversed = false;
        int intensity = 0;
        if (styles != null) {
            for (NTextStyle style : styles) {
                switch (style.getType()) {
                    case PRIMARY: 
                    case FORE_COLOR: {
                        foreground = NColor.of8(style.getVariant());
                        break;
                    }
                    case SECONDARY: 
                    case BACK_COLOR: {
                        background = NColor.of8(style.getVariant());
                        break;
                    }
                    case FORE_TRUE_COLOR: {
                        foreground = NColor.of24(style.getVariant());
                        break;
                    }
                    case BACK_TRUE_COLOR: {
                        background = NColor.of24(style.getVariant());
                        break;
                    }
                    case ITALIC: {
                        italic = true;
                        break;
                    }
                    case BOLD: {
                        bold = true;
                        break;
                    }
                    case BLINK: {
                        blink = true;
                        break;
                    }
                    case STRIKED: {
                        striked = true;
                        break;
                    }
                    case REVERSED: {
                        reversed = true;
                        break;
                    }
                    case UNDERLINED: {
                        underlined = true;
                    }
                }
            }
        }
        return this.styled(foreground, background, bold, blink, underlined, striked, italic, reversed, intensity);
    }

    public String foreColor(NColor c) {
        if (c != null) {
            switch (c.getBits()) {
                case BITS_4: {
                    int intColor = c.getIntColor();
                    if (intColor <= 0) {
                        intColor = 0;
                    }
                    if (intColor >= 15) {
                        intColor = 15;
                    }
                    return "" + FG8[intColor];
                }
                case BITS_8: {
                    int intColor = c.getIntColor();
                    if (intColor <= 0) {
                        intColor = 0;
                    }
                    if (intColor >= 255) {
                        intColor = 255;
                    }
                    return "38;5;" + intColor;
                }
                case BITS_16: 
                case BITS_24: 
                case BITS_32: 
                case BITS_64: {
                    int red = c.getRed();
                    int green = c.getGreen();
                    int blue = c.getBlue();
                    return "38;2;" + red + ";" + green + ";" + blue;
                }
            }
            int red = c.getRed();
            int green = c.getGreen();
            int blue = c.getBlue();
            return "38;2;" + red + ";" + green + ";" + blue;
        }
        return null;
    }

    public String backColor(NColor c) {
        if (c != null) {
            switch (c.getBits()) {
                case BITS_4: {
                    int intColor = c.getIntColor();
                    if (intColor <= 0) {
                        intColor = 0;
                    }
                    if (intColor >= 15) {
                        intColor = 15;
                    }
                    return "" + BG8[intColor];
                }
                case BITS_8: {
                    int intColor = c.getIntColor();
                    if (intColor <= 0) {
                        intColor = 0;
                    }
                    if (intColor >= 255) {
                        intColor = 255;
                    }
                    return "48;5;" + intColor;
                }
                case BITS_16: 
                case BITS_24: 
                case BITS_32: 
                case BITS_64: {
                    int red = c.getRed();
                    int green = c.getGreen();
                    int blue = c.getBlue();
                    return "48;2;" + red + ";" + green + ";" + blue;
                }
            }
        }
        return null;
    }

    public String styled(NColor foreground, NColor background, boolean bold, boolean blink, boolean underlined, boolean striked, boolean italic, boolean reversed, int intensity) {
        boolean plain;
        boolean bl = plain = !bold && !blink && !underlined && !italic && !striked && !reversed && NBlankable.isBlank(foreground) && NBlankable.isBlank(background);
        if (plain) {
            return this.plain();
        }
        StringBuilder sb = new StringBuilder("\u001b[");
        boolean first = true;
        if (foreground != null) {
            first = false;
            sb.append(this.foreColor(foreground));
        }
        if (background != null) {
            if (first) {
                first = false;
            } else {
                sb.append(';');
            }
            sb.append(this.backColor(background));
        }
        if (bold) {
            if (first) {
                first = false;
            } else {
                sb.append(';');
            }
            sb.append("1");
        }
        if (blink) {
            if (first) {
                first = false;
            } else {
                sb.append(';');
            }
            sb.append("5");
        }
        if (underlined) {
            if (first) {
                first = false;
            } else {
                sb.append(';');
            }
            sb.append("4");
        }
        if (striked) {
            if (first) {
                first = false;
            } else {
                sb.append(';');
            }
            sb.append("9");
        }
        if (italic) {
            if (first) {
                first = false;
            } else {
                sb.append(';');
            }
            sb.append("3");
        }
        if (reversed) {
            if (first) {
                first = false;
            } else {
                sb.append(';');
            }
            sb.append("7");
        }
        sb.append("m");
        return sb.toString();
    }

    public String command(NTerminalCmd command) {
        switch (command.getName()) {
            case "move-line-start": {
                return "\r";
            }
            case "move-to": {
                List<String> a = command.getArgs();
                if (a.size() >= 2) {
                    Integer col = NLiteral.of(a.get(0)).asInt().orNull();
                    Integer row = NLiteral.of(a.get(1)).asInt().orNull();
                    if (col != null && row != null) {
                        return "\u001b[" + row + ";" + col + "H";
                    }
                }
                return null;
            }
            case "move-up": {
                Integer count1;
                List<String> a = command.getArgs();
                if (a.size() >= 1 && (count1 = NLiteral.of(a.get(0)).asInt().orNull()) != null) {
                    return "\u001b[" + count1 + "A";
                }
                return null;
            }
            case "move-down": {
                Integer count1;
                List<String> a = command.getArgs();
                if (a.size() >= 1 && (count1 = NLiteral.of(a.get(0)).asInt().orNull()) != null) {
                    return "\u001b[" + count1 + "B";
                }
                return null;
            }
            case "move-right": {
                Integer count1;
                List<String> a = command.getArgs();
                if (a.size() >= 1 && (count1 = NLiteral.of(a.get(0)).asInt().orNull()) != null) {
                    return "\u001b[" + count1 + "C";
                }
                return null;
            }
            case "move-left": {
                Integer count1;
                List<String> a = command.getArgs();
                if (a.size() >= 1 && (count1 = NLiteral.of(a.get(0)).asInt().orNull()) != null) {
                    return "\u001b[" + count1 + "D";
                }
                return null;
            }
            case "clear-screen": {
                return "\u001b[2J";
            }
            case "clear-screen-from-cursor": {
                return "\u001b[0J";
            }
            case "clear-screen-to-cursor": {
                return "\u001b[1J";
            }
            case "clear-line": {
                return "\u001b[2K";
            }
            case "clear-line-from-cursor": {
                return "\u001b[0K";
            }
            case "clear-line-to-cursor": {
                return "\u001b[1K";
            }
        }
        return null;
    }
}

