/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.io;

import java.util.function.Supplier;
import net.thevpc.nuts.io.NContentMetadata;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NOptional;

public class DefaultNContentMetadata
implements NContentMetadata {
    private Supplier<Long> contentLength;
    private Supplier<NMsg> message;
    private Supplier<String> contentType;
    private Supplier<String> name;
    private Supplier<String> kind;
    private Supplier<String> charset;

    public DefaultNContentMetadata(NContentMetadata other) {
        if (other != null) {
            this.contentLength = () -> other.getContentLength().orNull();
            this.name = () -> other.getName().orNull();
            this.message = () -> other.getMessage().orNull();
            this.kind = () -> other.getKind().orNull();
            this.contentType = () -> other.getContentType().orNull();
            this.charset = () -> other.getCharset().orNull();
        } else {
            this.contentLength = null;
            this.name = null;
            this.message = null;
            this.kind = null;
            this.contentType = null;
            this.charset = null;
        }
    }

    public DefaultNContentMetadata() {
    }

    @Override
    public boolean isBlank() {
        if (this.contentLength != null && this.contentLength.get() != null && this.contentLength.get() >= 0L) {
            return false;
        }
        if (this.message != null && this.message.get() != null) {
            return false;
        }
        if (this.contentType != null && this.contentType.get() != null) {
            return false;
        }
        if (this.name != null && this.name.get() != null) {
            return false;
        }
        if (this.kind != null && this.kind.get() != null) {
            return false;
        }
        return this.charset == null || this.charset.get() == null;
    }

    public DefaultNContentMetadata(NMsg message, Long contentLength, String contentType, String charset, String kind) {
        this.contentLength = contentLength == null ? null : () -> contentLength;
        this.name = message == null ? null : () -> NText.of(message).filteredText();
        this.message = message == null ? null : () -> message;
        this.kind = kind == null ? null : () -> kind;
        this.contentType = contentType == null ? null : () -> contentType;
    }

    public DefaultNContentMetadata(String name, NMsg message, Long contentLength, String contentType, String charset, String kind) {
        this.contentLength = contentLength == null ? null : () -> contentLength;
        this.name = name == null ? null : () -> name;
        this.message = message == null ? null : () -> message;
        this.kind = kind == null ? null : () -> kind;
        this.contentType = contentType == null ? null : () -> contentType;
    }

    @Override
    public NOptional<Long> getContentLength() {
        return NOptional.ofNamed(this.contentLength == null ? null : this.contentLength.get(), "contentLength");
    }

    @Override
    public NOptional<String> getContentType() {
        return NOptional.ofNamed(this.contentType == null ? null : this.contentType.get(), "contentType");
    }

    @Override
    public NOptional<String> getName() {
        return NOptional.ofNamed(this.name == null ? null : this.name.get(), "name");
    }

    @Override
    public NOptional<String> getKind() {
        return NOptional.ofNamed(this.kind == null ? null : this.kind.get(), "kind");
    }

    @Override
    public NOptional<NMsg> getMessage() {
        return NOptional.ofNamed(this.message == null ? null : this.message.get(), "message");
    }

    @Override
    public NOptional<String> getCharset() {
        return NOptional.ofNamed(this.charset == null ? null : this.charset.get(), "encoding");
    }

    @Override
    public NContentMetadata setKind(String kind) {
        this.kind = () -> kind;
        return this;
    }

    @Override
    public NContentMetadata setContentLength(Long contentLength) {
        this.contentLength = () -> contentLength;
        return this;
    }

    @Override
    public NContentMetadata setMessage(NMsg message) {
        this.message = () -> message;
        return this;
    }

    @Override
    public DefaultNContentMetadata setContentType(String contentType) {
        this.contentType = () -> contentType;
        return this;
    }

    @Override
    public DefaultNContentMetadata setName(String name) {
        this.name = () -> name;
        return this;
    }

    @Override
    public DefaultNContentMetadata setCharset(String charset) {
        this.charset = () -> charset;
        return this;
    }

    public String toString() {
        String n;
        NMsg obj;
        if (this.message != null && (obj = this.message.get()) != null) {
            return NText.of(obj).filteredText();
        }
        if (this.name != null && (n = this.name.get()) != null) {
            return n;
        }
        return "InputSourceMetadata";
    }
}

