/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal.util;

import java.io.EOFException;
import java.io.UncheckedIOException;

public final class NReservedSimpleCharQueue {
    private char[] content;
    private int index;

    public NReservedSimpleCharQueue(char[] value) {
        this.content = value;
    }

    public boolean hasNext() {
        return this.index < this.content.length;
    }

    public int length() {
        return this.content.length - this.index;
    }

    public char peek() {
        if (this.index < this.content.length) {
            return this.content[this.index];
        }
        throw new UncheckedIOException(new EOFException());
    }

    public String peek(int count) {
        int c = this.length();
        if (count < c) {
            return new String(this.content, this.index, count);
        }
        return new String(this.content, this.index, c);
    }

    public String read(int count) {
        if (this.index + count < this.content.length) {
            String s = new String(this.content, this.index, count);
            this.index += count;
            return s;
        }
        String s = new String(this.content, this.index, this.content.length - this.index);
        this.index = this.content.length;
        return s;
    }

    public void skip(int count) {
        this.index = this.index + count < this.content.length ? (this.index += count) : this.content.length;
    }

    public char read() {
        if (this.index < this.content.length) {
            return this.content[this.index++];
        }
        throw new UncheckedIOException(new EOFException());
    }

    public char readAt(int index) {
        if (index >= 0 && index < this.length()) {
            return this.content[this.index + index];
        }
        throw new IndexOutOfBoundsException("invalid index " + index);
    }

    public String toString() {
        int c = this.length();
        return new String(this.content, this.index, c);
    }
}

