/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal.optional;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NMessagedPredicate;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStream;

public abstract class NReservedOptionalImpl<T>
implements NOptional<T>,
Cloneable {
    private NOptional.ExceptionFactory exceptionFactory;

    @Override
    public <V> NOptional<V> thenOptional(Function<T, NOptional<V>> mapper) {
        if (this.isPresent()) {
            NOptional<V> u = mapper.apply(this.get());
            if (u == null) {
                return NOptional.ofEmpty(this.getMessage());
            }
            return u;
        }
        return NOptional.ofEmpty(this.getMessage());
    }

    @Override
    public <V> NOptional<V> instanceOf(Class<V> targetClass) {
        NAssert.requireNonNull(targetClass, "type");
        return this.map(a -> {
            if (targetClass.isInstance(a)) {
                return a;
            }
            return null;
        });
    }

    @Override
    public NStream<T> stream() {
        return NStream.ofOptional(this);
    }

    @Override
    public T get() {
        return this.get(null);
    }

    @Override
    public <V> NOptional<V> flatMap(Function<T, NOptional<V>> mapper) {
        NAssert.requireNonNull(mapper);
        if (this.isPresent()) {
            return NAssert.requireNonNull(mapper.apply(this.get()));
        }
        return this;
    }

    @Override
    public <V> NOptional<V> mapIfPresent(Function<T, V> mapper) {
        if (this.isPresent()) {
            return this.map(mapper);
        }
        return this;
    }

    @Override
    public <V> NOptional<V> mapIfNotBlank(Function<T, V> mapper) {
        if (this.isBlank()) {
            return NOptional.ofEmpty(this.getMessage());
        }
        return this.map(mapper);
    }

    @Override
    public <V> NOptional<V> mapIfNotEmpty(Function<T, V> mapper) {
        if (this.isEmpty()) {
            return NOptional.ofEmpty(this.getMessage());
        }
        return this.map(mapper);
    }

    @Override
    public <V> NOptional<V> mapIfNotNull(Function<T, V> mapper) {
        if (this.isEmpty()) {
            return NOptional.ofEmpty(this.getMessage());
        }
        T v = this.get();
        if (v == null) {
            return NOptional.ofEmpty(this.getMessage());
        }
        return this.map(mapper);
    }

    @Override
    public <V> NOptional<V> mapIfNotError(Function<T, V> mapper) {
        if (this.isEmpty()) {
            return NOptional.ofEmpty(this.getMessage());
        }
        return this.map(mapper);
    }

    @Override
    public NOptional<T> mapIf(Predicate<T> predicate, Function<T, T> trueExpr) {
        if (this.isEmpty() || this.isError()) {
            return this;
        }
        T t = this.get();
        boolean ok = predicate != null && predicate.test(t);
        return ok ? NOptional.of(trueExpr.apply(t)) : this;
    }

    @Override
    public <V> NOptional<V> mapIf(Predicate<T> predicate, Function<T, V> trueExpr, Function<T, V> falseExpr) {
        if (this.isEmpty() || this.isError()) {
            return NOptional.of(falseExpr.apply(null));
        }
        T t = this.get();
        boolean ok = predicate != null && predicate.test(t);
        return NOptional.of(ok ? trueExpr.apply(t) : falseExpr.apply(t));
    }

    public boolean isDefault() {
        if (this.isBlank()) {
            return true;
        }
        if (this.isNotPresent()) {
            return false;
        }
        T v = this.get();
        if (v == null) {
            return true;
        }
        if (v instanceof Boolean) {
            return (Boolean)v == false;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue() == 0.0;
        }
        return false;
    }

    @Override
    public NOptional<T> mapIfNotDefault(Function<T, T> mapper) {
        if (this.isDefault()) {
            return this;
        }
        return this.map(mapper);
    }

    @Override
    public NOptional<T> mapIfDefault(Function<T, T> mapper) {
        if (!this.isDefault()) {
            return this;
        }
        return this.map(mapper);
    }

    @Override
    public <V> NOptional<V> map(Function<T, V> mapper) {
        NAssert.requireNonNull(mapper);
        if (this.isPresent()) {
            return NOptional.of(mapper.apply(this.get()));
        }
        return this;
    }

    @Override
    public <V> NOptional<V> then(Function<T, V> mapper) {
        NAssert.requireNonNull(mapper);
        switch (this.getType()) {
            case PRESENT: {
                try {
                    T y = this.get();
                    if (y != null) {
                        try {
                            return NOptional.of(mapper.apply(y));
                        }
                        catch (Exception ex) {
                            return NOptional.ofError(this.getMessage(), (Throwable)ex);
                        }
                    }
                    return NOptional.ofEmpty(this.getMessage());
                }
                catch (Exception ex) {
                    return NOptional.ofError(this.getMessage(), (Throwable)ex);
                }
            }
            case EMPTY: {
                return NOptional.ofEmpty(this.getMessage());
            }
            case ERROR: {
                return NOptional.ofError(this.getMessage(), this.getError());
            }
        }
        return NOptional.ofEmpty(this.getMessage());
    }

    @Override
    public NOptional<T> filter(NMessagedPredicate<T> predicate) {
        NAssert.requireNonNull(predicate);
        Predicate<T> filter = predicate.filter();
        NAssert.requireNonNull(filter);
        if (this.isPresent()) {
            return filter.test(this.get()) ? this : NOptional.ofEmpty(predicate.message());
        }
        return this;
    }

    @Override
    public NOptional<T> filter(Predicate<T> predicate, Supplier<NMsg> message) {
        NAssert.requireNonNull(predicate);
        if (this.isPresent()) {
            return predicate.test(this.get()) ? this : NOptional.ofEmpty(message);
        }
        return this;
    }

    @Override
    public NOptional<T> filter(Predicate<T> predicate) {
        return this.filter(predicate, null);
    }

    @Override
    public NOptional<T> ifPresent(Consumer<T> t) {
        if (this.isPresent()) {
            NAssert.requireNonNull(t);
            t.accept(this.get());
        }
        return this;
    }

    @Override
    public <R extends Throwable> T orElseThrow(Supplier<? extends R> exceptionSupplier) throws R {
        if (this.isPresent()) {
            return this.get();
        }
        throw NAssert.requireNonNull((Throwable)NAssert.requireNonNull(exceptionSupplier).get());
    }

    @Override
    public NOptional<T> orElseUse(Supplier<NOptional<T>> other) {
        if (this.isEmpty()) {
            return NAssert.requireNonNull(NAssert.requireNonNull(other).get());
        }
        return this;
    }

    @Override
    public T orElse(T other) {
        if (this.isNotPresent()) {
            return other;
        }
        return this.get();
    }

    @Override
    public T orElseGet(Supplier<? extends T> other) {
        if (this.isNotPresent()) {
            NAssert.requireNonNull(other);
            return other.get();
        }
        return this.get();
    }

    @Override
    public NOptional<T> orElseOf(Supplier<T> other) {
        if (this.isNotPresent()) {
            return NOptional.of(NAssert.requireNonNull(other).get(), this.getMessage());
        }
        return this;
    }

    @Override
    public NOptional<T> orElseOfNullable(Supplier<T> other) {
        if (this.isNotPresent()) {
            return NOptional.ofNullable(NAssert.requireNonNull(other).get());
        }
        return this;
    }

    @Override
    public T ifEmptyGet(Supplier<? extends T> other) {
        if (this.isNotPresent()) {
            NAssert.requireNonNull(other);
            return other.get();
        }
        return this.get();
    }

    @Override
    public NOptional<T> ifEmptyOf(Supplier<T> other) {
        if (this.isNotPresent()) {
            return NOptional.of(NAssert.requireNonNull(other).get(), this.getMessage());
        }
        return this;
    }

    @Override
    public NOptional<T> ifEmptyOfNullable(Supplier<T> other) {
        if (this.isNotPresent()) {
            return NOptional.ofNullable(NAssert.requireNonNull(other).get());
        }
        return this;
    }

    @Override
    public NOptional<T> ifBlankEmpty(Supplier<NMsg> emptyMessage) {
        T v;
        if (emptyMessage == null) {
            emptyMessage = () -> NMsg.ofPlain("blank value");
        }
        if (this.isPresent() && NBlankable.isBlank(v = this.get())) {
            return NOptional.ofEmpty(emptyMessage);
        }
        return this;
    }

    @Override
    public NOptional<T> ifBlankEmpty() {
        return this.ifBlankEmpty(null);
    }

    @Override
    public NOptional<T> ifBlankUse(Supplier<NOptional<T>> other) {
        if (this.isBlank()) {
            NAssert.requireNonNull(other);
            return NAssert.requireNonNull(other.get());
        }
        return this;
    }

    @Override
    public NOptional<T> ifNullUse(Supplier<NOptional<T>> other) {
        if (this.isNull()) {
            NAssert.requireNonNull(other);
            T v = this.get();
            if (v == null) {
                return NAssert.requireNonNull(other.get());
            }
        }
        return this;
    }

    @Override
    public NOptional<T> ifNullEmpty() {
        if (this.isNull()) {
            return NOptional.ofEmpty(this.getMessage());
        }
        return this;
    }

    @Override
    public NOptional<T> ifEmptyUse(Supplier<NOptional<T>> other) {
        if (this.isEmpty()) {
            NAssert.requireNonNull(other);
            return NAssert.requireNonNull(other.get());
        }
        return this;
    }

    @Override
    public NOptional<T> ifErrorUse(Supplier<NOptional<T>> other) {
        if (this.isError()) {
            NAssert.requireNonNull(other);
            return NAssert.requireNonNull(other.get());
        }
        return this;
    }

    @Override
    public NOptional<T> ifBlank(T other) {
        if (this.isBlank()) {
            return NOptional.ofNullable(other);
        }
        return this;
    }

    @Override
    public NOptional<T> ifEmptyNull() {
        return this.ifEmpty(null);
    }

    @Override
    public NOptional<T> ifErrorNull() {
        return this.ifError(null);
    }

    @Override
    public NOptional<T> ifEmpty(T other) {
        if (this.isEmpty()) {
            return NOptional.ofNullable(other);
        }
        return this;
    }

    @Override
    public NOptional<T> ifError(T other) {
        if (this.isError()) {
            return NOptional.ofNullable(other);
        }
        return this;
    }

    @Override
    public T orNull() {
        return this.orElse(null);
    }

    @Override
    public boolean isNotPresent() {
        return !this.isPresent();
    }

    @Override
    public NOptional<T> withExceptionFactory(NOptional.ExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
        return this;
    }

    @Override
    public NOptional.ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }
}

