/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.DefaultNEnvCondition;
import net.thevpc.nuts.artifact.DefaultNId;
import net.thevpc.nuts.artifact.NDependencyScope;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionInterval;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.internal.NReservedLangUtils;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.platform.NPlatformHome;
import net.thevpc.nuts.platform.NStoreType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NExceptions;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringMapFormat;
import net.thevpc.nuts.util.NStringUtils;

public final class NReservedUtils {
    public static String[] parseComplexStrings(String complex) {
        if (complex == null) {
            complex = "";
        }
        boolean EXPECT_REAL = false;
        boolean EXPECT_IMAG = true;
        boolean STATUS = false;
        int i = 0;
        StringBuilder real = new StringBuilder();
        StringBuilder imag = new StringBuilder();
        char[] chars = complex.toCharArray();
        block5: for (i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '+': 
                case '-': {
                    if (!STATUS) {
                        if (real.length() == 0 || real.toString().toLowerCase().endsWith("e")) {
                            real.append(chars[i]);
                            continue block5;
                        }
                        imag.append(chars[i]);
                        STATUS = true;
                        continue block5;
                    }
                    imag.append(chars[i]);
                    continue block5;
                }
                case 'i': 
                case '\u00ee': {
                    if (!STATUS) {
                        imag.append((CharSequence)real);
                        real.delete(0, real.length());
                        if (imag.length() == 0) {
                            imag.append("1");
                        } else if (imag.toString().equals("+") || imag.toString().equals("-")) {
                            imag.append("1");
                        }
                        STATUS = true;
                        continue block5;
                    }
                    if (imag.length() == 0) {
                        imag.append("1");
                        continue block5;
                    }
                    if (!imag.toString().equals("+") && !imag.toString().equals("-")) continue block5;
                    imag.append("1");
                    continue block5;
                }
                case '*': {
                    if (chars[i + 1] != 'i' && chars[i + 1] != '\u00ee' || STATUS) continue block5;
                    imag.append((CharSequence)real);
                    real.delete(0, real.length());
                    STATUS = true;
                    continue block5;
                }
                default: {
                    if (chars[i] >= '0' && chars[i] <= '9' || chars[i] == '.' || chars[i] == 'E' || chars[i] == 'e') {
                        if (!STATUS) {
                            real.append(chars[i]);
                            continue block5;
                        }
                        imag.append(chars[i]);
                        continue block5;
                    }
                    if (!STATUS) {
                        real.append(chars[i]);
                        continue block5;
                    }
                    imag.append(chars[i]);
                }
            }
        }
        if (real.length() == 0) {
            real.append("0");
        }
        if (imag.length() == 0) {
            imag.append("0");
        }
        return new String[]{real.toString(), imag.toString()};
    }

    public static String resolveJavaCommand(String javaHome) {
        String exe;
        String string = exe = NOsFamily.getCurrent().equals(NOsFamily.WINDOWS) ? "java.exe" : "java";
        if ((javaHome == null || javaHome.isEmpty()) && (NBlankable.isBlank(javaHome = System.getProperty("java.home")) || "null".equals(javaHome))) {
            return exe;
        }
        return javaHome + File.separator + "bin" + File.separator + exe;
    }

    public static String desc(Object s) {
        if (s == null) {
            return "<EMPTY>";
        }
        String ss = s instanceof Enum ? NNameFormat.CONST_NAME.format(((Enum)s).name()) : s.toString().trim();
        return ss.isEmpty() ? "<EMPTY>" : ss;
    }

    public static String coalesce(Object ... all) {
        for (Object object : all) {
            if (object == null) continue;
            return NReservedUtils.desc(object);
        }
        return NReservedUtils.desc(null);
    }

    public static boolean getSysBoolNutsProperty(String property, boolean defaultValue) {
        return NLiteral.of(System.getProperty("nuts." + property)).asBoolean().ifEmpty(defaultValue).orElse(false) != false || NLiteral.of(System.getProperty("nuts.export." + property)).asBoolean().ifEmpty(defaultValue).orElse(false) != false;
    }

    public static boolean isInfiniteLoopThread(String className, String methodName) {
        Thread thread = Thread.currentThread();
        StackTraceElement[] elements = thread.getStackTrace();
        if (elements == null || elements.length == 0) {
            return false;
        }
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[elements.length - (i + 1)];
            if (!className.equals(element.getClassName()) || !methodName.equals(element.getMethodName())) continue;
            return true;
        }
        return false;
    }

    public static String getHome(NStoreType storeFolder, NBootOptions bOptions) {
        return (bOptions.getSystem().orElse(false) != false ? NPlatformHome.ofSystem(bOptions.getStoreLayout().orNull()) : NPlatformHome.of(bOptions.getStoreLayout().orNull())).getWorkspaceLocation(storeFolder, bOptions.getHomeLocations().orNull(), bOptions.getName().orNull());
    }

    public static String getIdShortName(String groupId, String artifactId, String classifier) {
        StringBuilder sb = new StringBuilder();
        if (NBlankable.isBlank(classifier)) {
            if (!NBlankable.isBlank(groupId)) {
                sb.append(groupId).append(":");
            }
            sb.append(NStringUtils.trim(artifactId));
        } else {
            if (!NBlankable.isBlank(groupId)) {
                sb.append(groupId);
            }
            sb.append(":");
            sb.append(NStringUtils.trim(artifactId));
            sb.append(":");
            sb.append(classifier);
        }
        return sb.toString();
    }

    public static String getIdLongName(String groupId, String artifactId, NVersion version, String classifier) {
        StringBuilder sb = new StringBuilder();
        if (NBlankable.isBlank(classifier)) {
            if (!NBlankable.isBlank(groupId)) {
                sb.append(groupId).append(":");
            }
            sb.append(NStringUtils.trim(artifactId));
        } else {
            if (!NBlankable.isBlank(groupId)) {
                sb.append(groupId);
            }
            sb.append(":");
            sb.append(NStringUtils.trim(artifactId));
            sb.append(":");
            sb.append(classifier);
        }
        if (!NBlankable.isBlank(version)) {
            sb.append("#");
            sb.append(version);
        }
        return sb.toString();
    }

    public static boolean isAcceptCondition(NEnvCondition cond) {
        String earch;
        List<String> oss = NReservedLangUtils.uniqueNonBlankList(cond.getOs());
        List<String> archs = NReservedLangUtils.uniqueNonBlankList(cond.getArch());
        if (!oss.isEmpty()) {
            NOsFamily eos = NOsFamily.getCurrent();
            boolean osOk = false;
            for (String e : oss) {
                NId ee = NId.get(e).get();
                if (!ee.getShortName().equalsIgnoreCase(eos.id())) continue;
                if (!NReservedUtils.acceptVersion(ee.getVersion(), NVersion.of(System.getProperty("os.version")))) break;
                osOk = true;
                break;
            }
            if (!osOk) {
                return false;
            }
        }
        if (!archs.isEmpty() && (earch = System.getProperty("os.arch")) != null) {
            boolean archOk = false;
            for (String e : archs) {
                if (e.isEmpty() || !e.equalsIgnoreCase(earch)) continue;
                archOk = true;
                break;
            }
            return archOk;
        }
        return true;
    }

    public static String toDependencyExclusionListString(List<NId> exclusions) {
        TreeSet<String> ex = new TreeSet<String>();
        for (NId exclusion : exclusions) {
            ex.add(exclusion.getShortName());
        }
        return String.join((CharSequence)",", ex);
    }

    public static boolean isDependencyDefaultScope(String s1) {
        return NDependencyScope.parse(s1).orElse(NDependencyScope.API) == NDependencyScope.API;
    }

    public static boolean acceptVersion(NVersionInterval one, NVersion other) {
        int c;
        NVersion a = NVersion.of(one.getLowerBound());
        if (!a.isBlank()) {
            c = a.compareTo(other);
            if (one.isIncludeLowerBound() ? c > 0 : c >= 0) {
                return false;
            }
        }
        a = NVersion.of(one.getUpperBound());
        if (!a.isBlank()) {
            c = a.compareTo(other);
            if (one.isIncludeUpperBound()) {
                return c >= 0;
            }
            return c > 0;
        }
        return true;
    }

    public static boolean acceptVersion(NVersion one, NVersion other) {
        if (!other.isSingleValue()) {
            throw NExceptions.ofSafeIllegalArgumentException(NMsg.ofC("expected single value version: %s", other));
        }
        List<NVersionInterval> ii = one.intervals().get();
        if (ii.isEmpty()) {
            return true;
        }
        for (NVersionInterval i : ii) {
            if (!NReservedUtils.acceptVersion(i, other)) continue;
            return true;
        }
        return false;
    }

    public static NOptional<NId> parseId(String nutsId) {
        if (NBlankable.isBlank(nutsId = NStringUtils.trim(nutsId))) {
            return NOptional.of(NId.BLANK);
        }
        Matcher m = NId.PATTERN.matcher(nutsId);
        if (m.find()) {
            String group = m.group("group");
            String artifact = m.group("artifact");
            String classifier = m.group("classifier");
            String version = m.group("version");
            String query = m.group("query");
            if (artifact == null) {
                artifact = group;
                group = null;
            }
            LinkedHashSet condArch = new LinkedHashSet();
            LinkedHashSet condOs = new LinkedHashSet();
            LinkedHashSet condDist = new LinkedHashSet();
            LinkedHashSet condPlatform = new LinkedHashSet();
            LinkedHashSet condDE = new LinkedHashSet();
            ArrayList<String> condProfiles = new ArrayList<String>();
            Map<String, String> queryMap = NStringMapFormat.DEFAULT.parse(query).get();
            LinkedHashMap<String, String> idProperties = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> condProperties = new LinkedHashMap<String, String>();
            block20: for (Map.Entry<String, String> e : queryMap.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                switch (NStringUtils.trim(key)) {
                    case "classifier": {
                        classifier = value;
                        continue block20;
                    }
                    case "profile": {
                        condProfiles.addAll(NReservedLangUtils.splitDefault(value));
                        continue block20;
                    }
                    case "platform": {
                        condPlatform.addAll(NStringUtils.parsePropertyIdList(value).get());
                        continue block20;
                    }
                    case "osdist": {
                        condDist.addAll(NStringUtils.parsePropertyIdList(value).get());
                        continue block20;
                    }
                    case "arch": {
                        condArch.addAll(NStringUtils.parsePropertyIdList(value).get());
                        continue block20;
                    }
                    case "os": {
                        condOs.addAll(NStringUtils.parsePropertyIdList(value).get());
                        continue block20;
                    }
                    case "desktop": {
                        condDE.addAll(NStringUtils.parsePropertyIdList(value).get());
                        continue block20;
                    }
                    case "cond-properties": {
                        condProperties.putAll(NStringMapFormat.COMMA_FORMAT.parse(value).get());
                        continue block20;
                    }
                }
                idProperties.put(key, value);
            }
            return NOptional.of(new DefaultNId(group, artifact, classifier, NVersion.of(version), idProperties, (NEnvCondition)new DefaultNEnvCondition(new ArrayList<String>(condArch), new ArrayList<String>(condOs), new ArrayList<String>(condDist), new ArrayList<String>(condPlatform), new ArrayList<String>(condDE), new ArrayList<String>(condProfiles), condProperties)));
        }
        return NOptional.ofError(NMsg.ofC("invalid id format : %s", nutsId));
    }

    private static boolean ndiAddFileLine(Path filePath, String commentLine, String goodLine, boolean force, String ensureHeader, String headerReplace, NLog bLog) {
        boolean found = false;
        boolean updatedFile = false;
        ArrayList<String> lines = new ArrayList<String>();
        if (Files.isRegularFile(filePath, new LinkOption[0])) {
            String fileContent = null;
            try {
                fileContent = new String(Files.readAllBytes(filePath));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
            String[] fileRows = fileContent.split("\n");
            if (!(ensureHeader == null || fileRows.length != 0 && fileRows[0].trim().matches(ensureHeader))) {
                lines.add(headerReplace);
                updatedFile = true;
            }
            for (int i = 0; i < fileRows.length; ++i) {
                String row = fileRows[i];
                if (row.trim().equals("# " + commentLine)) {
                    lines.add(row);
                    found = true;
                    if (++i < fileRows.length && !fileRows[i].trim().equals(goodLine)) {
                        updatedFile = true;
                    }
                    lines.add(goodLine);
                    ++i;
                    while (i < fileRows.length) {
                        lines.add(fileRows[i]);
                        ++i;
                    }
                    continue;
                }
                lines.add(row);
            }
        }
        if (!found) {
            if (ensureHeader != null && headerReplace != null && lines.isEmpty()) {
                lines.add(headerReplace);
            }
            lines.add("# " + commentLine);
            lines.add(goodLine);
            updatedFile = true;
        }
        if (force || updatedFile) {
            try {
                Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                Files.write(filePath, (String.join((CharSequence)"\n", lines) + "\n").getBytes(), new OpenOption[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
        return updatedFile;
    }

    static boolean ndiRemoveFileCommented2Lines(Path filePath, String commentLine, boolean force, NLog bLog) {
        boolean found = false;
        boolean updatedFile = false;
        try {
            ArrayList<String> lines = new ArrayList<String>();
            if (Files.isRegularFile(filePath, new LinkOption[0])) {
                String fileContent = new String(Files.readAllBytes(filePath));
                String[] fileRows = fileContent.split("\n");
                for (int i = 0; i < fileRows.length; ++i) {
                    String row = fileRows[i];
                    if (row.trim().equals("# " + commentLine)) {
                        found = true;
                        i += 2;
                        while (i < fileRows.length) {
                            lines.add(fileRows[i]);
                            ++i;
                        }
                        continue;
                    }
                    lines.add(row);
                }
            }
            if (found) {
                updatedFile = true;
            }
            if (force || updatedFile) {
                if (!Files.exists(filePath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                }
                Files.write(filePath, (String.join((CharSequence)"\n", lines) + "\n").getBytes(), new OpenOption[0]);
            }
            return updatedFile;
        }
        catch (IOException ex) {
            bLog.log(NMsg.ofPlain("unable to update update " + filePath).asWarningAlert(ex));
            return false;
        }
    }

    public static String formatStringIdList(List<String> s) {
        LinkedHashSet<String> allIds = new LinkedHashSet<String>();
        if (s != null) {
            for (String s1 : s) {
                if ((s1 = NStringUtils.trim(s1)).length() <= 0) continue;
                allIds.add(s1);
            }
        }
        return String.join((CharSequence)",", allIds);
    }

    public static NOptional<List<String>> parseStringIdList(String s) {
        if (s == null) {
            return NOptional.of(Collections.emptyList());
        }
        LinkedHashSet<String> allIds = new LinkedHashSet<String>();
        StringBuilder q = null;
        boolean inBrackets = false;
        for (char c : s.toCharArray()) {
            if (q == null) {
                q = new StringBuilder();
                if (c == '[' || c == ']') {
                    inBrackets = true;
                    q.append(c);
                    continue;
                }
                if (c == ',' || Character.isWhitespace(c) || c == ';') continue;
                q.append(c);
                continue;
            }
            if (c == ',' || Character.isWhitespace(c) || c == ';') {
                if (inBrackets) {
                    q.append(c);
                    continue;
                }
                if (q.length() > 0) {
                    allIds.add(q.toString());
                }
                q = null;
                inBrackets = false;
                continue;
            }
            if (c == '[' || c == ']') {
                if (inBrackets) {
                    inBrackets = false;
                    q.append(c);
                    continue;
                }
                inBrackets = true;
                q.append(c);
                continue;
            }
            q.append(c);
        }
        if (q != null && q.length() > 0) {
            allIds.add(q.toString());
        }
        return NOptional.of(new ArrayList(allIds));
    }

    public static NOptional<List<NId>> parseIdList(String s) {
        ArrayList<NId> list = new ArrayList<NId>();
        NOptional<List<String>> o = NReservedUtils.parseStringIdList(s);
        if (o.isPresent()) {
            for (String x : o.get()) {
                NOptional<NId> y = NId.get(x).ifBlankEmpty();
                if (y.isError()) {
                    return NOptional.ofError(y.getMessage());
                }
                if (!y.isPresent()) continue;
                list.add(y.get());
            }
            return NOptional.of(list);
        }
        if (o.isError()) {
            return NOptional.ofError(o.getMessage());
        }
        return NOptional.ofEmpty(o.getMessage());
    }

    public static Map<String, String> toMap(NEnvCondition condition) {
        Map<String, String> properties;
        String s;
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (condition.getArch() != null && !NBlankable.isBlank(s = condition.getArch().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("arch", s);
        }
        if (condition.getOs() != null && !NBlankable.isBlank(s = condition.getOs().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("os", s);
        }
        if (condition.getOsDist() != null && !NBlankable.isBlank(s = condition.getOsDist().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("osdist", s);
        }
        if (condition.getPlatform() != null && !NBlankable.isBlank(s = NReservedUtils.formatStringIdList(condition.getPlatform()))) {
            m.put("platform", s);
        }
        if (condition.getDesktopEnvironment() != null && !NBlankable.isBlank(s = condition.getDesktopEnvironment().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("desktop", s);
        }
        if (condition.getProfiles() != null && !NBlankable.isBlank(s = condition.getProfiles().stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining(",")))) {
            m.put("profile", s);
        }
        if (condition.getProperties() != null && !(properties = condition.getProperties()).isEmpty()) {
            m.put("cond-properties", NStringMapFormat.DEFAULT.format(properties));
        }
        return m;
    }
}

