/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.internal;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.artifact.DefaultNVersionPart;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.artifact.NVersionPart;
import net.thevpc.nuts.artifact.NVersionPartType;
import net.thevpc.nuts.util.NStringUtils;

public class MavenNVersionComparator
implements NVersionComparator {
    public static final NVersionComparator INSTANCE = new MavenNVersionComparator();

    @Override
    public int compare(NVersion version1, NVersion version2) {
        String v2;
        String v1;
        if (version1 == null) {
            version1 = NVersion.BLANK;
        }
        if (version2 == null) {
            version2 = NVersion.BLANK;
        }
        if ((v1 = NStringUtils.trim(version1.getValue())).equals(v2 = NStringUtils.trim(version2.getValue()))) {
            return 0;
        }
        return this.compareVersionParts(version1.parts(), version2.parts());
    }

    public int compareVersionParts(List<NVersionPart> v1, List<NVersionPart> v2) {
        int i = 0;
        List<NVersionPart> v11 = MavenNVersionComparator.normalizeForComparison(v1);
        List<NVersionPart> v22 = MavenNVersionComparator.normalizeForComparison(v2);
        for (int j = 0; i < v11.size() || j < v22.size(); ++i, ++j) {
            NVersionPart a;
            if (i < v11.size() && j < v22.size()) {
                NVersionPart b;
                a = v11.get(i);
                int r = this.compareTo(a, b = v22.get(i));
                if (r == 0) continue;
                return r;
            }
            if (i < v11.size()) {
                a = v11.get(i);
                if (a.type() == NVersionPartType.QUALIFIER || a.type() == NVersionPartType.SUFFIX) {
                    if (a.value().equalsIgnoreCase("final") && i == v11.size() - 1) {
                        return 0;
                    }
                    switch (a.value().toLowerCase()) {
                        case "a": 
                        case "alpha": 
                        case "b": 
                        case "beta": 
                        case "m": 
                        case "milestone": 
                        case "rc": 
                        case "cr": 
                        case "snapshot": {
                            return -1;
                        }
                    }
                    return 1;
                }
                return 1;
            }
            NVersionPart b = v22.get(i);
            if (b.type() == NVersionPartType.QUALIFIER || b.type() == NVersionPartType.SUFFIX) {
                if (b.value().equalsIgnoreCase("final") && i == v22.size() - 1) {
                    return 0;
                }
                switch (b.value().toLowerCase()) {
                    case "a": 
                    case "alpha": 
                    case "b": 
                    case "beta": 
                    case "m": 
                    case "milestone": 
                    case "rc": 
                    case "cr": 
                    case "snapshot": {
                        return 1;
                    }
                }
                return -1;
            }
            return -1;
        }
        return 0;
    }

    private static List<NVersionPart> normalizeForComparison(List<NVersionPart> v1) {
        ArrayList<NVersionPart> ret = new ArrayList<NVersionPart>(v1);
        for (int i = ret.size() - 1; i >= 0; --i) {
            if (((NVersionPart)ret.get(i)).type() == NVersionPartType.SEPARATOR) {
                ret.remove(i);
                continue;
            }
            if (((NVersionPart)ret.get(i)).type() == NVersionPartType.QUALIFIER && ("final".equalsIgnoreCase(((NVersionPart)ret.get(i)).value()) || "ga".equalsIgnoreCase(((NVersionPart)ret.get(i)).value()))) {
                ret.remove(i);
                continue;
            }
            if (((NVersionPart)ret.get(i)).type() == NVersionPartType.SUFFIX && ("final".equalsIgnoreCase(((NVersionPart)ret.get(i)).value()) || "ga".equalsIgnoreCase(((NVersionPart)ret.get(i)).value()))) {
                ret.remove(i);
                continue;
            }
            if (((NVersionPart)ret.get(i)).type() == NVersionPartType.NUMBER) {
                if (!new BigInteger(((NVersionPart)ret.get(i)).value()).equals(BigInteger.ZERO) || i != ret.size() - 1 && (i >= ret.size() - 1 || ((NVersionPart)ret.get(i + 1)).type() == NVersionPartType.NUMBER)) continue;
                ret.remove(i);
                continue;
            }
            if (((NVersionPart)ret.get(i)).type() != NVersionPartType.SUFFIX && ((NVersionPart)ret.get(i)).type() != NVersionPartType.PREFIX) continue;
            ret.set(i, new DefaultNVersionPart(((NVersionPart)ret.get(i)).value(), NVersionPartType.QUALIFIER));
        }
        return ret;
    }

    public int compareTo(NVersionPart v1, NVersionPart v2) {
        if (v1.equals(v2)) {
            return 0;
        }
        if (v1.type() == NVersionPartType.SEPARATOR && v2.type() == NVersionPartType.SEPARATOR) {
            if (v1.value().equals("-")) {
                return -1;
            }
            return 1;
        }
        if (v1.type() == NVersionPartType.SEPARATOR) {
            return -1;
        }
        if (v2.type() == NVersionPartType.SEPARATOR) {
            return 1;
        }
        if (v1.type() == NVersionPartType.NUMBER && v2.type() == NVersionPartType.NUMBER) {
            return new BigInteger(v1.value()).compareTo(new BigInteger(v2.value()));
        }
        if (v1.type() == NVersionPartType.NUMBER) {
            return 1;
        }
        if (v2.type() == NVersionPartType.NUMBER) {
            return -1;
        }
        if (v1.type() == NVersionPartType.QUALIFIER && v2.type() == NVersionPartType.QUALIFIER) {
            Integer q1 = MavenNVersionComparator.getKnownQualifierIndex(v1.value());
            Integer q2 = MavenNVersionComparator.getKnownQualifierIndex(v2.value());
            if (q1 != null && q2 != null) {
                return q1.compareTo(q2);
            }
            if (q1 != null) {
                return -1;
            }
            if (q2 != null) {
                return 1;
            }
            return v1.value().compareToIgnoreCase(v2.value());
        }
        return v1.value().compareToIgnoreCase(v2.value());
    }

    private static Integer getKnownQualifierIndex(String v1) {
        switch (v1.toLowerCase()) {
            case "a": 
            case "alpha": {
                return 1;
            }
            case "b": 
            case "beta": {
                return 2;
            }
            case "m": 
            case "milestone": {
                return 3;
            }
            case "rc": 
            case "cr": {
                return 4;
            }
            case "snapshot": {
                return 5;
            }
            case "": 
            case "ga": 
            case "final": {
                return 6;
            }
            case "sp": {
                return 7;
            }
            case "release": {
                return 0x7FFFFFFE;
            }
            case "latest": {
                return Integer.MAX_VALUE;
            }
        }
        return null;
    }
}

