/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.expr;

import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.util.NStringUtils;

public class NToken {
    public static final int TT_EOL = 10;
    public static final int TT_EOF = -1;
    public static final int TT_NUMBER = -2;
    public static final int TT_WORD = -3;
    public static final int TT_NOTHING = -4;
    public static final int TT_INT = -10;
    public static final int TT_LONG = -11;
    public static final int TT_BIG_INT = -12;
    public static final int TT_FLOAT = -13;
    public static final int TT_DOUBLE = -14;
    public static final int TT_BIG_DECIMAL = -15;
    public static final int TT_COMMENTS = -16;
    public static final int TT_SPACE = -17;
    public static final int TT_STRING_LITERAL = -18;
    public static final int TT_AND = -40;
    public static final int TT_OR = -41;
    public static final int TT_LEFT_SHIFT = -42;
    public static final int TT_RIGHT_SHIFT = -43;
    public static final int TT_LEFT_SHIFT_UNSIGNED = -44;
    public static final int TT_RIGHT_SHIFT_UNSIGNED = -45;
    public static final int TT_LTE = -46;
    public static final int TT_GTE = -47;
    public static final int TT_LTGT = -48;
    public static final int TT_EQ2 = -49;
    public static final int TT_NEQ = -50;
    public static final int TT_NEQ2 = -51;
    public static final int TT_RIGHT_ARROW = -52;
    public static final int TT_RIGHT_ARROW2 = -53;
    public static final int TT_QUOTE_SINGLE3 = -54;
    public static final int TT_QUOTE_DOUBLE3 = -55;
    public static final int TT_QUOTE_ANTI3 = -56;
    public static final int TT_COMMENT_LINE_C = -57;
    public static final int TT_COMMENT_LINE_SH = -58;
    public static final int TT_COMMENT_MULTILINE_C = -59;
    public static final int TT_COMMENT_MULTILINE_XML = -60;
    public static final int TT_MUL_MUL = -61;
    public static final int TT_PLUS_PLUS = -62;
    public static final int TT_MINUS_MINUS = -63;
    public static final int TT_DIV_DIV = -64;
    public static final int TT_POW_POW = -65;
    public static final int TT_REM_REM = -66;
    public static final int TT_MUL_EQ = -67;
    public static final int TT_PLUS_EQ = -68;
    public static final int TT_MINUS_EQ = -69;
    public static final int TT_DIV_EQ = -70;
    public static final int TT_POW_EQ = -71;
    public static final int TT_REM_EQ = -72;
    public static final int TT_ISTR_DQ = -73;
    public static final int TT_ISTR_SQ = -74;
    public static final int TT_ISTR_AQ = -75;
    public static final int TT_COALESCE = -76;
    public static final int TT_DOTS2 = -77;
    public static final int TT_DOTS3 = -78;
    public static final int TT_EQ3 = -79;
    public static final int TT_NOT3 = -80;
    public static final int TT_NOT2 = -81;
    public static final int TT_NOT_LIKE = -82;
    public static final int TT_LIKE2 = -83;
    public static final int TT_LIKE3 = -84;
    public static final int TT_DOLLAR = -85;
    public static final int TT_DOLLAR_BRACE = -86;
    public static final int TT_VAR = -87;
    public static final int TT_DEFAULT = Integer.MIN_VALUE;
    public static final int TT_EQ = 61;
    public static final int TT_NOT = 33;
    public static final int TT_LT = 60;
    public static final int TT_GT = 62;
    public static final int TT_LIKE = 126;
    public static final int TT_AMP = 38;
    public static final int TT_PIPE = 124;
    public static final int TT_OPEN_BRACKET = 91;
    public static final int TT_CLOSE_BRACKET = 93;
    public static final int TT_OPEN_BRACE = 123;
    public static final int TT_CLOSE_BRACE = 125;
    public static final int TT_OPEN_PAR = 40;
    public static final int TT_CLOSE_PAR = 41;
    public int ttype;
    public int lineno;
    public String sval;
    public String image;
    public String ttypeString;
    public Number nval;

    public static NToken ofSpecial(int ttype, String sval, int lineno) {
        String ttypeString;
        switch (ttype) {
            case 9: {
                ttypeString = "'\\t'";
                break;
            }
            case 12: {
                ttypeString = "'\\f'";
                break;
            }
            default: {
                ttypeString = ttype >= 32 ? "'" + (char)ttype + "'" : String.valueOf(ttype);
            }
        }
        return new NToken(ttype, sval, 0, lineno, sval, ttypeString);
    }

    public static NToken ofChar(char ttype, int lineno) {
        String sval = String.valueOf(ttype);
        return new NToken(ttype, sval, 0, lineno, sval, "'" + sval + "'");
    }

    public static NToken ofStr(int ttype, String sval, String ttypeString, int lineno) {
        return new NToken(ttype, sval, 0, lineno, sval, ttypeString);
    }

    public static NToken of(int ttype, String sval, Number nval, int lineno, String image, String ttypeString) {
        return new NToken(ttype, sval, nval, lineno, image, ttypeString);
    }

    public NToken(int ttype, String sval, Number nval, int lineno, String image, String ttypeString) {
        this.ttype = ttype;
        this.sval = sval;
        this.nval = nval;
        this.lineno = lineno;
        this.image = image;
        this.ttypeString = ttypeString;
    }

    public static String typeString(int ttype) {
        switch (ttype) {
            case -1: {
                return "EOF";
            }
            case 10: {
                return "EOL";
            }
            case -10: {
                return "INT";
            }
            case -11: {
                return "LONG";
            }
            case -12: {
                return "BIG_INT";
            }
            case -13: {
                return "FLOAT";
            }
            case -14: {
                return "DOUBLE";
            }
            case -15: {
                return "BIG_DECIMAL";
            }
            case -3: {
                return "WORD";
            }
            case -4: {
                return "NOTHING";
            }
            case -18: {
                return "STRING_LITERAL";
            }
            case -17: {
                return "SPACE";
            }
            case -40: {
                return "AND";
            }
            case -41: {
                return "OR";
            }
            case -42: {
                return "LEFT_SHIFT";
            }
            case -43: {
                return "RIGHT_SHIFT";
            }
            case -44: {
                return "LEFT_SHIFT_UNSIGNED";
            }
            case -45: {
                return "RIGHT_SHIFT_UNSIGNED";
            }
            case -46: {
                return "LTE";
            }
            case -47: {
                return "GTE";
            }
            case -48: {
                return "LTGT";
            }
            case -49: {
                return "EQ2";
            }
            case -50: {
                return "NEQ";
            }
            case -51: {
                return "NEQ2";
            }
            case -52: {
                return "RIGHT_ARROW";
            }
            case -53: {
                return "RIGHT_ARROW2";
            }
            case -76: {
                return "COALESCE";
            }
            case -77: {
                return "DOTS2";
            }
            case -78: {
                return "DOTS3";
            }
            case -79: {
                return "EQ3";
            }
            case -80: {
                return "NOT3";
            }
            case -81: {
                return "NOT2";
            }
            case -82: {
                return "NOT_LIKE";
            }
            case -83: {
                return "LIKE2";
            }
            case -84: {
                return "LIKE3";
            }
            case 61: {
                return "EQ";
            }
            case 33: {
                return "NOT";
            }
            case 60: {
                return "LT";
            }
            case 62: {
                return "GT";
            }
            case 126: {
                return "LIKE";
            }
            case 38: {
                return "AMP";
            }
            case 124: {
                return "PIPE";
            }
            case 91: {
                return "OPEN_BRACKET";
            }
            case 93: {
                return "CLOSE_BRACKET";
            }
            case 123: {
                return "OPEN_BRACE";
            }
            case 125: {
                return "CLOSE_BRACE";
            }
            case 40: {
                return "OPEN_PAR";
            }
            case 41: {
                return "CLOSE_PAR";
            }
            case -85: {
                return "TT_DOLLAR";
            }
            case -86: {
                return "DOLLAR_BRACE";
            }
            case -87: {
                return "VAR";
            }
            case -16: {
                return "COMMENTS";
            }
            case -70: {
                return "DIV_EQ";
            }
            case -2147483648: {
                return "TT_DEFAULT";
            }
            case 9: {
                return "'\\t'";
            }
            case 12: {
                return "'\\f'";
            }
        }
        if (ttype >= 32) {
            return "'" + (char)ttype + "'";
        }
        return String.valueOf(ttype);
    }

    public String toString() {
        String ts = this.ttypeString == null ? NToken.typeString(this.ttype) : this.ttypeString;
        return "NToken{ttype=" + NToken.typeString(this.ttype) + ", lineno=" + this.lineno + ", sval=" + (this.sval == null ? "null" : NStringUtils.formatStringLiteral(this.sval, NElementType.SINGLE_QUOTED_STRING)) + ", nval=" + this.nval + '}';
    }
}

