/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.expr;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public enum NExprCommonOp implements NEnum
{
    PLUS("+", new String[0]),
    MINUS("-", new String[0]),
    MUL("*", new String[0]),
    DIV("/", new String[0]),
    REM("%", new String[0]),
    XOR("^", new String[0]),
    POW("**", new String[0]),
    OR_BITS("|", new String[0]),
    AND_BITS("&", new String[0]),
    OR("||", new String[0]),
    AND("&&", new String[0]),
    EQ("==", new String[0]),
    NOT("!", new String[0]),
    LT("<", new String[0]),
    GT(">", new String[0]),
    LTE("<=", new String[0]),
    GTE(">=", new String[0]),
    NE("!=", new String[0]),
    DOT(".", new String[0]),
    ASSIGN("=", new String[0]);

    private final String id = NNameFormat.ID_NAME.format(this.name());
    private final String image;
    private final String[] aliases;
    private static final Map<String, NExprCommonOp> byImage;

    private static void register(String id, NExprCommonOp value) {
        if (byImage.containsKey(id)) {
            throw new IllegalArgumentException("duplicate image: " + value.name());
        }
        byImage.put(id, value);
    }

    private NExprCommonOp(String image, String ... aliases) {
        this.image = image;
        this.aliases = aliases;
    }

    public static NOptional<NExprCommonOp> parse(String value) {
        return NEnumUtils.parseEnum(value, NExprCommonOp.class, s -> {
            NExprCommonOp u = byImage.get(NStringUtils.trim(value).toLowerCase());
            return NOptional.of(u);
        });
    }

    @Override
    public String id() {
        return this.id;
    }

    public String image() {
        return this.image;
    }

    static {
        byImage = new HashMap<String, NExprCommonOp>();
        for (NExprCommonOp value : NExprCommonOp.values()) {
            HashSet<String> u = new HashSet<String>(Arrays.asList(value.name().toLowerCase(), value.id().toLowerCase(), value.image.toLowerCase()));
            for (String alias : value.aliases) {
                u.add(NStringUtils.trim(alias.toLowerCase()));
            }
            for (String s : u) {
                NExprCommonOp.register(s, value);
            }
        }
    }
}

