/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.elem;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NNumberLayout implements NEnum
{
    BINARY,
    DECIMAL,
    OCTAL,
    HEXADECIMAL;

    private final String id = NNameFormat.ID_NAME.format(this.name());

    public static NOptional<NNumberLayout> parse(String value) {
        return NEnumUtils.parseEnum(value, NNumberLayout.class, ev -> {
            switch (ev.getNormalizedValue()) {
                case "BINARY": 
                case "BIN": {
                    return NOptional.of(BINARY);
                }
                case "DECIMAL": 
                case "DEC": {
                    return NOptional.of(DECIMAL);
                }
                case "OCTAL": 
                case "OCT": {
                    return NOptional.of(OCTAL);
                }
                case "HEXADECIMAL": 
                case "HEXA": 
                case "HEX": {
                    return NOptional.of(HEXADECIMAL);
                }
            }
            return null;
        });
    }

    public int radix() {
        switch (this.ordinal()) {
            case 0: {
                return 2;
            }
            case 2: {
                return 8;
            }
            case 1: {
                return 10;
            }
            case 3: {
                return 16;
            }
        }
        throw new IllegalArgumentException("unexpected NNumberLayout");
    }

    @Override
    public String id() {
        return this.id();
    }
}

