/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.elem;

import net.thevpc.nuts.text.NContentType;

public final class NElementUtils {
    private NElementUtils() {
    }

    public static boolean isValidElementNameChar(char c, boolean start) {
        return !(start ? !Character.isJavaIdentifierStart(c) && c != '.' && c != ':' && c != '@' : !Character.isJavaIdentifierPart(c) && c != '.' && c != '-' && c != ':' && c != '@');
    }

    public static boolean isValidElementNameChar(char c, boolean start, NContentType contentType) {
        if (contentType == null) {
            return NElementUtils.isValidElementNameChar(c, start);
        }
        switch (contentType) {
            case XML: {
                if (start ? !Character.isJavaIdentifierStart(c) && c != '.' && c != ':' : !Character.isJavaIdentifierPart(c) && c != '.' && c != '-' && c != ':') {
                    return false;
                }
            }
            case TSON: {
                if (!(start ? !Character.isJavaIdentifierStart(c) && c != '.' && c != '@' : !Character.isJavaIdentifierPart(c) && c != '.' && c != '-' && c != '@')) break;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidElementName(String name) {
        if (name == null) {
            return false;
        }
        if (name.isEmpty()) {
            return false;
        }
        char[] charArray = name.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (!(i == 0 ? !Character.isJavaIdentifierStart(c) && c != '.' && c != '@' && c != ':' : !Character.isJavaIdentifierPart(c) && c != '.' && c != '-' && c != '@' && c != ':')) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidElementName(String name, NContentType contentType) {
        if (contentType == null) {
            return NElementUtils.isValidElementName(name);
        }
        if (name == null) {
            return false;
        }
        if (name.isEmpty()) {
            return false;
        }
        char[] charArray = name.toCharArray();
        switch (contentType) {
            case XML: {
                for (int i = 0; i < charArray.length; ++i) {
                    char c = charArray[i];
                    if (!(i == 0 ? !Character.isJavaIdentifierStart(c) && c != '.' && c != ':' : !Character.isJavaIdentifierPart(c) && c != '.' && c != '-' && c != ':')) continue;
                    return false;
                }
                break;
            }
            case JSON: {
                for (int i = 0; i < charArray.length; ++i) {
                    char c = charArray[i];
                    if (!(i == 0 ? !Character.isJavaIdentifierStart(c) && c != '.' && c != '@' : !Character.isJavaIdentifierPart(c) && c != '.' && c != '-' && c != '@')) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }
}

